/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.OptionsParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class OptionsParser {
    static final Log LOG = LogFactory.getLog(OptionsParser.class);
    private static final Options cliOptions = new Options();

    private static void checkSnapshotsArgs(String[] snapshots) {
        Preconditions.checkArgument((snapshots != null && snapshots.length == 2 && !StringUtils.isBlank((String)snapshots[0]) && !StringUtils.isBlank((String)snapshots[1]) ? 1 : 0) != 0, (Object)"Must provide both the starting and ending snapshot names");
    }

    public static DistCpOptions parse(String[] args) throws IllegalArgumentException {
        String[] snapshots;
        CommandLine command;
        CustomParser parser = new CustomParser(null);
        try {
            command = parser.parse(cliOptions, args, true);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse arguments. " + Arrays.toString(args), e);
        }
        DistCpOptions option = OptionsParser.parseSourceAndTargetPaths((CommandLine)command);
        if (command.hasOption(DistCpOptionSwitch.IGNORE_FAILURES.getSwitch())) {
            option.setIgnoreFailures(true);
        }
        if (command.hasOption(DistCpOptionSwitch.ATOMIC_COMMIT.getSwitch())) {
            option.setAtomicCommit(true);
        }
        if (command.hasOption(DistCpOptionSwitch.WORK_PATH.getSwitch()) && option.shouldAtomicCommit()) {
            String workPath = OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.WORK_PATH.getSwitch());
            if (workPath != null && !workPath.isEmpty()) {
                option.setAtomicWorkPath(new Path(workPath));
            }
        } else if (command.hasOption(DistCpOptionSwitch.WORK_PATH.getSwitch())) {
            throw new IllegalArgumentException("-tmp work-path can only be specified along with -atomic");
        }
        if (command.hasOption(DistCpOptionSwitch.LOG_PATH.getSwitch())) {
            option.setLogPath(new Path(OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.LOG_PATH.getSwitch())));
        }
        if (command.hasOption(DistCpOptionSwitch.SYNC_FOLDERS.getSwitch())) {
            option.setSyncFolder(true);
        }
        if (command.hasOption(DistCpOptionSwitch.OVERWRITE.getSwitch())) {
            option.setOverwrite(true);
        }
        if (command.hasOption(DistCpOptionSwitch.APPEND.getSwitch())) {
            option.setAppend(true);
        }
        if (command.hasOption(DistCpOptionSwitch.DELETE_MISSING.getSwitch())) {
            option.setDeleteMissing(true);
        }
        if (command.hasOption(DistCpOptionSwitch.SKIP_CRC.getSwitch())) {
            option.setSkipCRC(true);
        }
        if (command.hasOption(DistCpOptionSwitch.BLOCKING.getSwitch())) {
            option.setBlocking(false);
        }
        OptionsParser.parseBandwidth((CommandLine)command, (DistCpOptions)option);
        if (command.hasOption(DistCpOptionSwitch.SSL_CONF.getSwitch())) {
            option.setSslConfigurationFile(command.getOptionValue(DistCpOptionSwitch.SSL_CONF.getSwitch()));
        }
        OptionsParser.parseNumListStatusThreads((CommandLine)command, (DistCpOptions)option);
        OptionsParser.parseMaxMaps((CommandLine)command, (DistCpOptions)option);
        if (command.hasOption(DistCpOptionSwitch.COPY_STRATEGY.getSwitch())) {
            option.setCopyStrategy(OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.COPY_STRATEGY.getSwitch()));
        }
        OptionsParser.parsePreserveStatus((CommandLine)command, (DistCpOptions)option);
        if (command.hasOption(DistCpOptionSwitch.DIFF.getSwitch())) {
            snapshots = OptionsParser.getVals((CommandLine)command, (String)DistCpOptionSwitch.DIFF.getSwitch());
            OptionsParser.checkSnapshotsArgs((String[])snapshots);
            option.setUseDiff(snapshots[0], snapshots[1]);
        }
        if (command.hasOption(DistCpOptionSwitch.RDIFF.getSwitch())) {
            snapshots = OptionsParser.getVals((CommandLine)command, (String)DistCpOptionSwitch.RDIFF.getSwitch());
            OptionsParser.checkSnapshotsArgs((String[])snapshots);
            option.setUseRdiff(snapshots[0], snapshots[1]);
        }
        OptionsParser.parseFileLimit((CommandLine)command);
        OptionsParser.parseSizeLimit((CommandLine)command);
        if (command.hasOption(DistCpOptionSwitch.FILTERS.getSwitch())) {
            option.setFiltersFile(OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.FILTERS.getSwitch()));
        }
        OptionsParser.parseBlocksPerChunk((CommandLine)command, (DistCpOptions)option);
        OptionsParser.parseCopyBufferSize((CommandLine)command, (DistCpOptions)option);
        if (command.hasOption(DistCpOptionSwitch.VERBOSE_LOG.getSwitch())) {
            option.setVerboseLog(true);
        }
        return option;
    }

    private static void parseBlocksPerChunk(CommandLine command, DistCpOptions option) {
        boolean hasOption = command.hasOption(DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch());
        LOG.info((Object)("parseChunkSize: " + DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch() + " " + hasOption));
        if (hasOption) {
            String chunkSizeString = OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch().trim());
            try {
                int csize = Integer.parseInt(chunkSizeString);
                if (csize < 0) {
                    csize = 0;
                }
                LOG.info((Object)("Set distcp blocksPerChunk to " + csize));
                option.setBlocksPerChunk(csize);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("blocksPerChunk is invalid: " + chunkSizeString, e);
            }
        }
    }

    private static void parseCopyBufferSize(CommandLine command, DistCpOptions option) {
        if (command.hasOption(DistCpOptionSwitch.COPY_BUFFER_SIZE.getSwitch())) {
            String copyBufferSizeStr = OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.COPY_BUFFER_SIZE.getSwitch().trim());
            try {
                int copyBufferSize = Integer.parseInt(copyBufferSizeStr);
                option.setCopyBufferSize(copyBufferSize);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("copyBufferSize is invalid: " + copyBufferSizeStr, e);
            }
        }
    }

    private static void parseSizeLimit(CommandLine command) {
        if (command.hasOption(DistCpOptionSwitch.SIZE_LIMIT.getSwitch())) {
            String sizeLimitString = OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.SIZE_LIMIT.getSwitch().trim());
            try {
                Long.parseLong(sizeLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Size-limit is invalid: " + sizeLimitString, e);
            }
            LOG.warn((Object)(DistCpOptionSwitch.SIZE_LIMIT.getSwitch() + " is a deprecated" + " option. Ignoring."));
        }
    }

    private static void parseFileLimit(CommandLine command) {
        if (command.hasOption(DistCpOptionSwitch.FILE_LIMIT.getSwitch())) {
            String fileLimitString = OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.FILE_LIMIT.getSwitch().trim());
            try {
                Integer.parseInt(fileLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("File-limit is invalid: " + fileLimitString, e);
            }
            LOG.warn((Object)(DistCpOptionSwitch.FILE_LIMIT.getSwitch() + " is a deprecated" + " option. Ignoring."));
        }
    }

    private static void parsePreserveStatus(CommandLine command, DistCpOptions option) {
        block4: {
            if (!command.hasOption(DistCpOptionSwitch.PRESERVE_STATUS.getSwitch())) break block4;
            String attributes = OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.PRESERVE_STATUS.getSwitch());
            if (attributes == null || attributes.isEmpty()) {
                for (DistCpOptions.FileAttribute attribute : DistCpOptions.FileAttribute.values()) {
                    option.preserve(attribute);
                }
            } else {
                for (int index = 0; index < attributes.length(); ++index) {
                    option.preserve(DistCpOptions.FileAttribute.getAttribute((char)attributes.charAt(index)));
                }
            }
        }
    }

    private static void parseMaxMaps(CommandLine command, DistCpOptions option) {
        if (command.hasOption(DistCpOptionSwitch.MAX_MAPS.getSwitch())) {
            try {
                Integer maps = Integer.parseInt(OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.MAX_MAPS.getSwitch()).trim());
                option.setMaxMaps(maps.intValue());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number of maps is invalid: " + OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.MAX_MAPS.getSwitch()), e);
            }
        }
    }

    private static void parseNumListStatusThreads(CommandLine command, DistCpOptions option) {
        if (command.hasOption(DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch())) {
            try {
                Integer numThreads = Integer.parseInt(OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch()).trim());
                option.setNumListstatusThreads(numThreads.intValue());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number of liststatus threads is invalid: " + OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch()), e);
            }
        }
    }

    private static void parseBandwidth(CommandLine command, DistCpOptions option) {
        if (command.hasOption(DistCpOptionSwitch.BANDWIDTH.getSwitch())) {
            try {
                Integer mapBandwidth = Integer.parseInt(OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.BANDWIDTH.getSwitch()).trim());
                if (mapBandwidth <= 0) {
                    throw new IllegalArgumentException("Bandwidth specified is not positive: " + mapBandwidth);
                }
                option.setMapBandwidth(mapBandwidth.intValue());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bandwidth specified is invalid: " + OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.BANDWIDTH.getSwitch()), e);
            }
        }
    }

    private static DistCpOptions parseSourceAndTargetPaths(CommandLine command) {
        DistCpOptions option;
        ArrayList<Path> sourcePaths = new ArrayList<Path>();
        String[] leftOverArgs = command.getArgs();
        if (leftOverArgs == null || leftOverArgs.length < 1) {
            throw new IllegalArgumentException("Target path not specified");
        }
        Path targetPath = new Path(leftOverArgs[leftOverArgs.length - 1].trim());
        for (int index = 0; index < leftOverArgs.length - 1; ++index) {
            sourcePaths.add(new Path(leftOverArgs[index].trim()));
        }
        if (command.hasOption(DistCpOptionSwitch.SOURCE_FILE_LISTING.getSwitch())) {
            if (!sourcePaths.isEmpty()) {
                throw new IllegalArgumentException("Both source file listing and source paths present");
            }
            option = new DistCpOptions(new Path(OptionsParser.getVal((CommandLine)command, (String)DistCpOptionSwitch.SOURCE_FILE_LISTING.getSwitch())), targetPath);
        } else {
            if (sourcePaths.isEmpty()) {
                throw new IllegalArgumentException("Neither source file listing nor source paths present");
            }
            option = new DistCpOptions(sourcePaths, targetPath);
        }
        return option;
    }

    private static String getVal(CommandLine command, String swtch) {
        String optionValue = command.getOptionValue(swtch);
        if (optionValue == null) {
            return null;
        }
        return optionValue.trim();
    }

    private static String[] getVals(CommandLine command, String option) {
        return command.getOptionValues(option);
    }

    public static void usage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("distcp OPTIONS [source_path...] <target_path>\n\nOPTIONS", cliOptions);
    }

    static {
        for (DistCpOptionSwitch option : DistCpOptionSwitch.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding option " + option.getOption()));
            }
            cliOptions.addOption(option.getOption());
        }
    }
}

