/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Random;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistCpUtils {
    private static final Log LOG = LogFactory.getLog(TestDistCpUtils.class);
    private static final Configuration config = new Configuration();
    private static MiniDFSCluster cluster;
    private static Random rand;

    @BeforeClass
    public static void create() throws IOException {
        cluster = new MiniDFSCluster.Builder(config).numDataNodes(1).format(true).build();
    }

    @AfterClass
    public static void destroy() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testGetRelativePathRoot() {
        Path root = new Path("/tmp/abc");
        Path child = new Path("/tmp/abc/xyz/file");
        Assert.assertEquals((Object)DistCpUtils.getRelativePath((Path)root, (Path)child), (Object)"/xyz/file");
        root = new Path("/");
        child = new Path("/a");
        Assert.assertEquals((Object)DistCpUtils.getRelativePath((Path)root, (Path)child), (Object)"/a");
    }

    @Test
    public void testPackAttributes() {
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"");
        attributes.add(DistCpOptions.FileAttribute.REPLICATION);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"R");
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"R"));
        attributes.add(DistCpOptions.FileAttribute.BLOCKSIZE);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RB");
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"RB"));
        attributes.add(DistCpOptions.FileAttribute.USER);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RBU");
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"RBU"));
        attributes.add(DistCpOptions.FileAttribute.GROUP);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RBUG");
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"RBUG"));
        attributes.add(DistCpOptions.FileAttribute.PERMISSION);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RBUGP");
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"RBUGP"));
    }

    @Test
    public void testPreserve() {
        try {
            FileSystem fs = FileSystem.get((Configuration)config);
            EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
            Path path = new Path("/tmp/abc");
            Path src = new Path("/tmp/src");
            fs.mkdirs(path);
            fs.mkdirs(src);
            FileStatus srcStatus = fs.getFileStatus(src);
            FsPermission noPerm = new FsPermission(0);
            fs.setPermission(path, noPerm);
            fs.setOwner(path, "nobody", "nobody");
            DistCpUtils.preserve((FileSystem)fs, (Path)path, (FileStatus)srcStatus, attributes);
            FileStatus target = fs.getFileStatus(path);
            Assert.assertEquals((Object)target.getPermission(), (Object)noPerm);
            Assert.assertEquals((Object)target.getOwner(), (Object)"nobody");
            Assert.assertEquals((Object)target.getGroup(), (Object)"nobody");
            attributes.add(DistCpOptions.FileAttribute.PERMISSION);
            DistCpUtils.preserve((FileSystem)fs, (Path)path, (FileStatus)srcStatus, attributes);
            target = fs.getFileStatus(path);
            Assert.assertEquals((Object)target.getPermission(), (Object)srcStatus.getPermission());
            Assert.assertEquals((Object)target.getOwner(), (Object)"nobody");
            Assert.assertEquals((Object)target.getGroup(), (Object)"nobody");
            attributes.add(DistCpOptions.FileAttribute.GROUP);
            attributes.add(DistCpOptions.FileAttribute.USER);
            DistCpUtils.preserve((FileSystem)fs, (Path)path, (FileStatus)srcStatus, attributes);
            target = fs.getFileStatus(path);
            Assert.assertEquals((Object)target.getPermission(), (Object)srcStatus.getPermission());
            Assert.assertEquals((Object)target.getOwner(), (Object)srcStatus.getOwner());
            Assert.assertEquals((Object)target.getGroup(), (Object)srcStatus.getGroup());
            fs.delete(path, true);
            fs.delete(src, true);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)"Preserve test failure");
        }
    }

    public static String createTestSetup(FileSystem fs) throws IOException {
        return TestDistCpUtils.createTestSetup((String)"/tmp1", (FileSystem)fs, (FsPermission)FsPermission.getDefault());
    }

    public static String createTestSetup(FileSystem fs, FsPermission perm) throws IOException {
        return TestDistCpUtils.createTestSetup((String)"/tmp1", (FileSystem)fs, (FsPermission)perm);
    }

    public static String createTestSetup(String baseDir, FileSystem fs, FsPermission perm) throws IOException {
        String base = TestDistCpUtils.getBase((String)baseDir);
        fs.mkdirs(new Path(base + "/newTest/hello/world1"));
        fs.mkdirs(new Path(base + "/newTest/hello/world2/newworld"));
        fs.mkdirs(new Path(base + "/newTest/hello/world3/oldworld"));
        fs.setPermission(new Path(base + "/newTest"), perm);
        fs.setPermission(new Path(base + "/newTest/hello"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world1"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world2"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world2/newworld"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world3"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world3/oldworld"), perm);
        TestDistCpUtils.createFile((FileSystem)fs, (String)(base + "/newTest/1"));
        TestDistCpUtils.createFile((FileSystem)fs, (String)(base + "/newTest/hello/2"));
        TestDistCpUtils.createFile((FileSystem)fs, (String)(base + "/newTest/hello/world3/oldworld/3"));
        TestDistCpUtils.createFile((FileSystem)fs, (String)(base + "/newTest/hello/world2/4"));
        return base;
    }

    private static String getBase(String base) {
        String location = String.valueOf(rand.nextLong());
        return base + "/" + location;
    }

    public static void delete(FileSystem fs, String path) {
        try {
            if (fs != null && path != null) {
                fs.delete(new Path(path), true);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception encountered ", (Throwable)e);
        }
    }

    public static void createFile(FileSystem fs, String filePath) throws IOException {
        FSDataOutputStream out = fs.create(new Path(filePath));
        IOUtils.closeStream((Closeable)out);
    }

    public static boolean checkIfFoldersAreInSync(FileSystem fs, String targetBase, String sourceBase) throws IOException {
        Path base = new Path(targetBase);
        Stack<Path> stack = new Stack<Path>();
        stack.push(base);
        while (!stack.isEmpty()) {
            FileStatus[] fStatus;
            Path file = (Path)stack.pop();
            if (!fs.exists(file) || (fStatus = fs.listStatus(file)) == null || fStatus.length == 0) continue;
            for (FileStatus status : fStatus) {
                if (status.isDirectory()) {
                    stack.push(status.getPath());
                }
                Assert.assertTrue((boolean)fs.exists(new Path(sourceBase + "/" + DistCpUtils.getRelativePath((Path)new Path(targetBase), (Path)status.getPath()))));
            }
        }
        return true;
    }

    static {
        rand = new Random();
    }
}

