/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestIntegration {
    private static final Log LOG = LogFactory.getLog(TestIntegration.class);
    private static FileSystem fs;
    private static Path listFile;
    private static Path target;
    private static String root;

    private static Configuration getConf() {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        conf.set("mapred.job.tracker", "local");
        return conf;
    }

    @BeforeClass
    public static void setup() {
        try {
            fs = FileSystem.get((Configuration)TestIntegration.getConf());
            listFile = new Path("target/tmp/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            target = new Path("target/tmp/target").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            root = new Path("target/tmp").makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
        }
    }

    @Test
    public void testSingleFileMissingTarget() {
        this.caseSingleFileMissingTarget(false);
        this.caseSingleFileMissingTarget(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileMissingTarget(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"singlefile1/file1"});
            this.createFiles(new String[]{"singlefile1/file1"});
            this.runTest(listFile, target, sync);
            this.checkResult(target, 1, new String[0]);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testSingleFileTargetFile() {
        this.caseSingleFileTargetFile(false);
        this.caseSingleFileTargetFile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileTargetFile(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"singlefile1/file1"});
            this.createFiles(new String[]{"singlefile1/file1", target.toString()});
            this.runTest(listFile, target, sync);
            this.checkResult(target, 1, new String[0]);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testSingleFileTargetDir() {
        this.caseSingleFileTargetDir(false);
        this.caseSingleFileTargetDir(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileTargetDir(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"singlefile2/file2"});
            this.createFiles(new String[]{"singlefile2/file2"});
            this.mkdirs(new String[]{target.toString()});
            this.runTest(listFile, target, sync);
            this.checkResult(target, 1, new String[]{"file2"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testSingleDirTargetMissing() {
        this.caseSingleDirTargetMissing(false);
        this.caseSingleDirTargetMissing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleDirTargetMissing(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"singledir"});
            this.mkdirs(new String[]{root + "/singledir/dir1"});
            this.runTest(listFile, target, sync);
            this.checkResult(target, 1, new String[]{"dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleDirTargetPresent() {
        try {
            this.addEntries(listFile, new String[]{"singledir"});
            this.mkdirs(new String[]{root + "/singledir/dir1"});
            this.mkdirs(new String[]{target.toString()});
            this.runTest(listFile, target, false);
            this.checkResult(target, 1, new String[]{"singledir/dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateSingleDirTargetPresent() {
        try {
            this.addEntries(listFile, new String[]{"Usingledir"});
            this.mkdirs(new String[]{root + "/Usingledir/Udir1"});
            this.mkdirs(new String[]{target.toString()});
            this.runTest(listFile, target, true);
            this.checkResult(target, 1, new String[]{"Udir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testMultiFileTargetPresent() {
        this.caseMultiFileTargetPresent(false);
        this.caseMultiFileTargetPresent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseMultiFileTargetPresent(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.mkdirs(new String[]{target.toString()});
            this.runTest(listFile, target, sync);
            this.checkResult(target, 3, new String[]{"file3", "file4", "file5"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    @Test
    public void testMultiFileTargetMissing() {
        this.caseMultiFileTargetMissing(false);
        this.caseMultiFileTargetMissing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseMultiFileTargetMissing(boolean sync) {
        try {
            this.addEntries(listFile, new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.runTest(listFile, target, sync);
            this.checkResult(target, 3, new String[]{"file3", "file4", "file5"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiDirTargetPresent() {
        try {
            this.addEntries(listFile, new String[]{"multifile", "singledir"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.mkdirs(new String[]{target.toString(), root + "/singledir/dir1"});
            this.runTest(listFile, target, false);
            this.checkResult(target, 2, new String[]{"multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateMultiDirTargetPresent() {
        try {
            this.addEntries(listFile, new String[]{"Umultifile", "Usingledir"});
            this.createFiles(new String[]{"Umultifile/Ufile3", "Umultifile/Ufile4", "Umultifile/Ufile5"});
            this.mkdirs(new String[]{target.toString(), root + "/Usingledir/Udir1"});
            this.runTest(listFile, target, true);
            this.checkResult(target, 4, new String[]{"Ufile3", "Ufile4", "Ufile5", "Udir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiDirTargetMissing() {
        try {
            this.addEntries(listFile, new String[]{"multifile", "singledir"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.mkdirs(new String[]{root + "/singledir/dir1"});
            this.runTest(listFile, target, false);
            this.checkResult(target, 2, new String[]{"multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateMultiDirTargetMissing() {
        try {
            this.addEntries(listFile, new String[]{"multifile", "singledir"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.mkdirs(new String[]{root + "/singledir/dir1"});
            this.runTest(listFile, target, true);
            this.checkResult(target, 4, new String[]{"file3", "file4", "file5", "dir1"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobTargetMissingSingleLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, new String[]{"*"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"singledir/dir2/file6"});
            this.runTest(listFile, target, false);
            this.checkResult(target, 2, new String[]{"multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir2/file6"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
            TestDistCpUtils.delete((FileSystem)fs, (String)"target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateGlobTargetMissingSingleLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, new String[]{"*"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"singledir/dir2/file6"});
            this.runTest(listFile, target, true);
            this.checkResult(target, 4, new String[]{"file3", "file4", "file5", "dir2/file6"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
            TestDistCpUtils.delete((FileSystem)fs, (String)"target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobTargetMissingMultiLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, new String[]{"*/*"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"singledir1/dir3/file7", "singledir1/dir3/file8", "singledir1/dir3/file9"});
            this.runTest(listFile, target, false);
            this.checkResult(target, 4, new String[]{"file3", "file4", "file5", "dir3/file7", "dir3/file8", "dir3/file9"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
            TestDistCpUtils.delete((FileSystem)fs, (String)"target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateGlobTargetMissingMultiLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, new String[]{"*/*"});
            this.createFiles(new String[]{"multifile/file3", "multifile/file4", "multifile/file5"});
            this.createFiles(new String[]{"singledir1/dir3/file7", "singledir1/dir3/file8", "singledir1/dir3/file9"});
            this.runTest(listFile, target, true);
            this.checkResult(target, 6, new String[]{"file3", "file4", "file5", "file7", "file8", "file9"});
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete((FileSystem)fs, (String)root);
            TestDistCpUtils.delete((FileSystem)fs, (String)"target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntries(Path listFile, String ... entries) throws IOException {
        FSDataOutputStream out = fs.create(listFile);
        try {
            for (String entry : entries) {
                out.write((root + "/" + entry).getBytes());
                out.write("\n".getBytes());
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(String ... entries) throws IOException {
        for (String entry : entries) {
            FSDataOutputStream out = fs.create(new Path(root + "/" + entry));
            try {
                out.write((root + "/" + entry).getBytes());
                out.write("\n".getBytes());
            }
            finally {
                out.close();
            }
        }
    }

    private void mkdirs(String ... entries) throws IOException {
        for (String entry : entries) {
            fs.mkdirs(new Path(entry));
        }
    }

    private void runTest(Path listFile, Path target, boolean sync) throws IOException {
        DistCpOptions options = new DistCpOptions(listFile, target);
        options.setSyncFolder(sync);
        try {
            new DistCp(TestIntegration.getConf(), options).execute();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void checkResult(Path target, int count, String ... relPaths) throws IOException {
        Assert.assertEquals((long)count, (long)fs.listStatus(target).length);
        if (relPaths == null || relPaths.length == 0) {
            Assert.assertTrue((String)target.toString(), (boolean)fs.exists(target));
            return;
        }
        for (String relPath : relPaths) {
            Assert.assertTrue((String)new Path(target, relPath).toString(), (boolean)fs.exists(new Path(target, relPath)));
        }
    }
}

