/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
@Ignore
public class TestDistCp {
    private static final Log LOG = LogFactory.getLog(TestDistCp.class);
    private static List<Path> pathList = new ArrayList();
    private static final int FILE_SIZE = 1024;
    private static Configuration configuration;
    private static MiniDFSCluster cluster;
    private static MiniMRCluster mrCluster;
    private static final String SOURCE_PATH = "/tmp/source";
    private static final String TARGET_PATH = "/tmp/target";

    @BeforeClass
    public static void setup() throws Exception {
        configuration = TestDistCp.getConfigurationForCluster();
        cluster = new MiniDFSCluster.Builder(configuration).numDataNodes(1).format(true).build();
        System.setProperty("org.apache.hadoop.mapred.TaskTracker", "target/tmp");
        configuration.set("org.apache.hadoop.mapred.TaskTracker", "target/tmp");
        System.setProperty("hadoop.log.dir", "target/tmp");
        configuration.set("hadoop.log.dir", "target/tmp");
        mrCluster = new MiniMRCluster(1, cluster.getFileSystem().getUri().toString(), 1);
        JobConf mrConf = mrCluster.createJobConf();
        String mrJobTracker = mrConf.get("mapred.job.tracker");
        configuration.set("mapred.job.tracker", mrJobTracker);
        String mrJobTrackerAddress = mrConf.get("mapred.job.tracker.http.address");
        configuration.set("mapred.job.tracker.http.address", mrJobTrackerAddress);
    }

    @AfterClass
    public static void cleanup() {
        if (mrCluster != null) {
            mrCluster.shutdown();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private static Configuration getConfigurationForCluster() throws IOException {
        Configuration configuration = new Configuration();
        System.setProperty("test.build.data", "target/build/TEST_DISTCP/data");
        configuration.set("hadoop.log.dir", "target/tmp");
        LOG.debug((Object)("fs.default.name  == " + configuration.get("fs.default.name")));
        LOG.debug((Object)("dfs.http.address == " + configuration.get("dfs.http.address")));
        return configuration;
    }

    private static void createSourceData() throws Exception {
        TestDistCp.mkdirs((String)"/tmp/source/1");
        TestDistCp.mkdirs((String)"/tmp/source/2");
        TestDistCp.mkdirs((String)"/tmp/source/2/3/4");
        TestDistCp.mkdirs((String)"/tmp/source/2/3");
        TestDistCp.mkdirs((String)"/tmp/source/5");
        TestDistCp.touchFile((String)"/tmp/source/5/6");
        TestDistCp.mkdirs((String)"/tmp/source/7");
        TestDistCp.mkdirs((String)"/tmp/source/7/8");
        TestDistCp.touchFile((String)"/tmp/source/7/8/9");
    }

    private static void mkdirs(String path) throws Exception {
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        Path qualifiedPath = new Path(path).makeQualified(fileSystem.getUri(), fileSystem.getWorkingDirectory());
        pathList.add(qualifiedPath);
        fileSystem.mkdirs(qualifiedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void touchFile(String path) throws Exception {
        FSDataOutputStream outputStream = null;
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path qualifiedPath = new Path(path).makeQualified(fs.getUri(), fs.getWorkingDirectory());
            long blockSize = fs.getDefaultBlockSize(new Path(path)) * 2L;
            outputStream = fs.create(qualifiedPath, true, 0, (short)(fs.getDefaultReplication(new Path(path)) * 2), blockSize);
            outputStream.write(new byte[1024]);
            pathList.add(qualifiedPath);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{outputStream});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{outputStream});
    }

    private static void clearState() throws Exception {
        pathList.clear();
        cluster.getFileSystem().delete(new Path("/tmp/target"), true);
        TestDistCp.createSourceData();
    }

    public void testUniformSizeDistCp() throws Exception {
        try {
            TestDistCp.clearState();
            DistributedFileSystem fileSystem = cluster.getFileSystem();
            Path sourcePath = new Path("/tmp/source").makeQualified(fileSystem.getUri(), fileSystem.getWorkingDirectory());
            ArrayList<Path> sources = new ArrayList<Path>();
            sources.add(sourcePath);
            Path targetPath = new Path("/tmp/target").makeQualified(fileSystem.getUri(), fileSystem.getWorkingDirectory());
            DistCpOptions options = new DistCpOptions(sources, targetPath);
            options.setAtomicCommit(true);
            options.setBlocking(false);
            Job job = new DistCp(configuration, options).execute();
            Path workDir = CopyOutputFormat.getWorkingDirectory((Job)job);
            Path finalDir = CopyOutputFormat.getCommitDirectory((Job)job);
            while (!job.isComplete() && !cluster.getFileSystem().exists(workDir)) {
            }
            job.waitForCompletion(true);
            Assert.assertFalse((boolean)cluster.getFileSystem().exists(workDir));
            Assert.assertTrue((boolean)cluster.getFileSystem().exists(finalDir));
            Assert.assertFalse((boolean)cluster.getFileSystem().exists(new Path(job.getConfiguration().get("distcp.meta.folder"))));
            TestDistCp.verifyResults();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered", (Throwable)e);
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testCleanup() {
        try {
            TestDistCp.clearState();
            Path sourcePath = new Path("noscheme:///file");
            ArrayList<Path> sources = new ArrayList<Path>();
            sources.add(sourcePath);
            DistributedFileSystem fs = cluster.getFileSystem();
            Path targetPath = new Path("/tmp/target").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            DistCpOptions options = new DistCpOptions(sources, targetPath);
            Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(configuration), (Configuration)configuration);
            stagingDir.getFileSystem(configuration).mkdirs(stagingDir);
            try {
                new DistCp(configuration, options).execute();
            }
            catch (Throwable t) {
                Assert.assertEquals((long)stagingDir.getFileSystem(configuration).listStatus(stagingDir).length, (long)0L);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)("testCleanup failed " + e.getMessage()));
        }
    }

    @Test
    public void testRootPath() throws Exception {
        try {
            TestDistCp.clearState();
            ArrayList<Path> sources = new ArrayList<Path>();
            DistributedFileSystem fs = cluster.getFileSystem();
            sources.add(new Path("/a").makeQualified(fs.getUri(), fs.getWorkingDirectory()));
            sources.add(new Path("/b").makeQualified(fs.getUri(), fs.getWorkingDirectory()));
            TestDistCp.touchFile((String)"/a/a.txt");
            TestDistCp.touchFile((String)"/b/b.txt");
            Path targetPath = new Path("/c").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            DistCpOptions options = new DistCpOptions(sources, targetPath);
            new DistCp(configuration, options).execute();
            Assert.assertTrue((boolean)fs.exists(new Path("/c/a/a.txt")));
            Assert.assertTrue((boolean)fs.exists(new Path("/c/b/b.txt")));
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered", (Throwable)e);
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testDynamicDistCp() throws Exception {
        try {
            TestDistCp.clearState();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path sourcePath = new Path("/tmp/source").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            ArrayList<Path> sources = new ArrayList<Path>();
            sources.add(sourcePath);
            Path targetPath = new Path("/tmp/target").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            DistCpOptions options = new DistCpOptions(sources, targetPath);
            options.setCopyStrategy("dynamic");
            options.setAtomicCommit(true);
            options.setAtomicWorkPath(new Path("/work"));
            options.setBlocking(false);
            Job job = new DistCp(configuration, options).execute();
            Path workDir = CopyOutputFormat.getWorkingDirectory((Job)job);
            Path finalDir = CopyOutputFormat.getCommitDirectory((Job)job);
            while (!job.isComplete() && !fs.exists(workDir)) {
            }
            job.waitForCompletion(true);
            Assert.assertFalse((boolean)fs.exists(workDir));
            Assert.assertTrue((boolean)fs.exists(finalDir));
            TestDistCp.verifyResults();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered", (Throwable)e);
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    private static void verifyResults() throws Exception {
        for (Path path : pathList) {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path sourcePath = path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
            Path targetPath = new Path(sourcePath.toString().replaceAll("/tmp/source", "/tmp/target"));
            Assert.assertTrue((boolean)fs.exists(targetPath));
            Assert.assertEquals((Object)fs.isFile(sourcePath), (Object)fs.isFile(targetPath));
        }
    }
}

