/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.utils.join;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.utils.join.SampleDataJoinMapper;
import org.apache.hadoop.contrib.utils.join.SampleDataJoinReducer;
import org.apache.hadoop.contrib.utils.join.SampleTaggedMapOutput;
import org.apache.hadoop.contrib.utils.join.TestDataJoin;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDataJoin
extends TestCase {
    private static MiniDFSCluster cluster = null;

    public static Test suite() {
        1 setup = new /* Unavailable Anonymous Inner Class!! */;
        return setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataJoin() throws Exception {
        int srcs = 4;
        JobConf job = new JobConf();
        job.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        Path base = cluster.getFileSystem().makeQualified(new Path("/inner"));
        Path[] src = TestDataJoin.writeSimpleSrc((Path)base, (JobConf)job, (int)4);
        job.setInputFormat(SequenceFileInputFormat.class);
        Path outdir = new Path(base, "out");
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outdir);
        job.setMapperClass(SampleDataJoinMapper.class);
        job.setReducerClass(SampleDataJoinReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(SampleTaggedMapOutput.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormat(TextOutputFormat.class);
        job.setNumMapTasks(1);
        job.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])src);
        try {
            JobClient.runJob((JobConf)job);
            TestDataJoin.confirmOutput((Path)outdir, (JobConf)job, (int)4);
        }
        finally {
            base.getFileSystem((Configuration)job).delete(base, true);
        }
    }

    private static void confirmOutput(Path out, JobConf job, int srcs) throws IOException {
        FileSystem fs = out.getFileSystem((Configuration)job);
        FileStatus[] outlist = fs.listStatus(out);
        TestDataJoin.assertEquals((int)1, (int)outlist.length);
        TestDataJoin.assertTrue((0L < outlist[0].getLen() ? 1 : 0) != 0);
        FSDataInputStream in = fs.open(outlist[0].getPath());
        LineRecordReader rr = new LineRecordReader((InputStream)in, 0L, Integer.MAX_VALUE, (Configuration)job);
        LongWritable k = new LongWritable();
        Text v = new Text();
        int count = 0;
        while (rr.next(k, v)) {
            int i;
            String[] vals = v.toString().split("\t");
            TestDataJoin.assertEquals((int)(srcs + 1), (int)vals.length);
            int[] ivals = new int[vals.length];
            for (i = 0; i < vals.length; ++i) {
                ivals[i] = Integer.parseInt(vals[i]);
            }
            TestDataJoin.assertEquals((int)0, (int)(ivals[0] % (srcs * srcs)));
            for (i = 1; i < vals.length; ++i) {
                TestDataJoin.assertEquals((int)((ivals[i] - (i - 1)) * srcs), (int)(10 * ivals[0]));
            }
            ++count;
        }
        TestDataJoin.assertEquals((int)4, (int)count);
    }

    private static SequenceFile.Writer[] createWriters(Path testdir, JobConf conf, int srcs, Path[] src) throws IOException {
        for (int i = 0; i < srcs; ++i) {
            src[i] = new Path(testdir, Integer.toString(i + 10, 36));
        }
        SequenceFile.Writer[] out = new SequenceFile.Writer[srcs];
        for (int i = 0; i < srcs; ++i) {
            out[i] = new SequenceFile.Writer(testdir.getFileSystem((Configuration)conf), (Configuration)conf, src[i], Text.class, Text.class);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path[] writeSimpleSrc(Path testdir, JobConf conf, int srcs) throws IOException {
        SequenceFile.Writer[] out = null;
        Path[] src = new Path[srcs];
        try {
            out = TestDataJoin.createWriters((Path)testdir, (JobConf)conf, (int)srcs, (Path[])src);
            int capacity = srcs * 2 + 1;
            Text key = new Text();
            key.set("ignored");
            Text val = new Text();
            for (int k = 0; k < capacity; ++k) {
                for (int i = 0; i < srcs; ++i) {
                    val.set(Integer.toString(k % srcs == 0 ? k * srcs : k * srcs + i) + "\t" + Integer.toString(10 * k + i));
                    out[i].append((Writable)key, (Writable)val);
                    if (i != k) continue;
                    out[i].append((Writable)key, (Writable)val);
                }
            }
        }
        finally {
            if (out != null) {
                for (int i = 0; i < srcs; ++i) {
                    if (out[i] == null) continue;
                    out[i].close();
                }
            }
        }
        return src;
    }

    static /* synthetic */ MiniDFSCluster access$002(MiniDFSCluster x0) {
        cluster = x0;
        return cluster;
    }

    static /* synthetic */ MiniDFSCluster access$000() {
        return cluster;
    }
}

