/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.utils.join;

import java.io.IOException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.contrib.utils.join.ArrayListBackedIterator;
import org.apache.hadoop.contrib.utils.join.JobBase;
import org.apache.hadoop.contrib.utils.join.ResetableIterator;
import org.apache.hadoop.contrib.utils.join.TaggedMapOutput;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class DataJoinReducerBase
extends JobBase {
    protected Reporter reporter = null;
    private long maxNumOfValuesPerGroup = 100L;
    protected long largestNumOfValues = 0L;
    protected long numOfValues = 0L;
    protected long collected = 0L;
    protected JobConf job;
    public static Text SOURCE_TAGS_FIELD = new Text("SOURCE_TAGS");
    public static Text NUM_OF_VALUES_FIELD = new Text("NUM_OF_VALUES");

    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.setStatus(super.getReport());
        }
    }

    public void configure(JobConf job) {
        super.configure(job);
        this.job = job;
        this.maxNumOfValuesPerGroup = job.getLong("datajoin.maxNumOfValuesPerGroup", 100L);
    }

    protected ResetableIterator createResetableIterator() {
        return new ArrayListBackedIterator();
    }

    private SortedMap<Object, ResetableIterator> regroup(Object key, Iterator arg1, Reporter reporter) throws IOException {
        this.numOfValues = 0L;
        TreeMap<Object, ResetableIterator> retv = new TreeMap<Object, ResetableIterator>();
        TaggedMapOutput aRecord = null;
        while (arg1.hasNext()) {
            ++this.numOfValues;
            if (this.numOfValues % 100L == 0L) {
                reporter.setStatus("key: " + key.toString() + " numOfValues: " + this.numOfValues);
            }
            if (this.numOfValues > this.maxNumOfValuesPerGroup) continue;
            aRecord = ((TaggedMapOutput)arg1.next()).clone(this.job);
            Text tag = aRecord.getTag();
            ResetableIterator data = (ResetableIterator)retv.get(tag);
            if (data == null) {
                data = this.createResetableIterator();
                retv.put(tag, data);
            }
            data.add((Object)aRecord);
        }
        if (this.numOfValues > this.largestNumOfValues) {
            this.largestNumOfValues = this.numOfValues;
            LOG.info((Object)("key: " + key.toString() + " this.largestNumOfValues: " + this.largestNumOfValues));
        }
        return retv;
    }

    public void reduce(Object key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
        int i;
        if (this.reporter == null) {
            this.reporter = reporter;
        }
        SortedMap groups = this.regroup(key, values, reporter);
        Object[] tags = groups.keySet().toArray();
        ResetableIterator[] groupValues = new ResetableIterator[tags.length];
        for (i = 0; i < tags.length; ++i) {
            groupValues[i] = (ResetableIterator)groups.get(tags[i]);
        }
        this.joinAndCollect(tags, groupValues, key, output, reporter);
        this.addLongValue((Object)"groupCount", 1L);
        for (i = 0; i < tags.length; ++i) {
            groupValues[i].close();
        }
    }

    protected void collect(Object key, TaggedMapOutput aRecord, OutputCollector output, Reporter reporter) throws IOException {
        ++this.collected;
        this.addLongValue((Object)"collectedCount", 1L);
        if (aRecord != null) {
            output.collect(key, (Object)aRecord.getData());
            reporter.setStatus("key: " + key.toString() + " collected: " + this.collected);
            this.addLongValue((Object)"actuallyCollectedCount", 1L);
        }
    }

    private void joinAndCollect(Object[] tags, ResetableIterator[] values, Object key, OutputCollector output, Reporter reporter) throws IOException {
        if (values.length < 1) {
            return;
        }
        Object[] partialList = new Object[values.length];
        this.joinAndCollect(tags, values, 0, partialList, key, output, reporter);
    }

    private void joinAndCollect(Object[] tags, ResetableIterator[] values, int pos, Object[] partialList, Object key, OutputCollector output, Reporter reporter) throws IOException {
        if (values.length == pos) {
            TaggedMapOutput combined = this.combine(tags, partialList);
            this.collect(key, combined, output, reporter);
            return;
        }
        ResetableIterator nextValues = values[pos];
        nextValues.reset();
        while (nextValues.hasNext()) {
            Object v;
            partialList[pos] = v = nextValues.next();
            this.joinAndCollect(tags, values, pos + 1, partialList, key, output, reporter);
        }
    }

    protected abstract TaggedMapOutput combine(Object[] var1, Object[] var2);

    public void map(Object arg0, Object arg1, OutputCollector arg2, Reporter arg3) throws IOException {
    }
}

