/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.InstrumentedReadLock;
import org.apache.hadoop.util.InstrumentedReadWriteLock;
import org.apache.hadoop.util.InstrumentedWriteLock;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestInstrumentedReadWriteLock {
    static final Log LOG = LogFactory.getLog(TestInstrumentedReadWriteLock.class);
    @Rule
    public TestName name = new TestName();

    @Test(timeout=10000L)
    public void testWriteLock() throws Exception {
        String testname = this.name.getMethodName();
        final ThreadLocal<Boolean> locked = new ThreadLocal<Boolean>();
        locked.set(Boolean.FALSE);
        InstrumentedReadWriteLock readWriteLock = new InstrumentedReadWriteLock(true, testname, LOG, 2000L, 300L);
        final AutoCloseableLock writeLock = new AutoCloseableLock(readWriteLock.writeLock()){

            public AutoCloseableLock acquire() {
                AutoCloseableLock lock = super.acquire();
                locked.set(Boolean.TRUE);
                return lock;
            }

            public void release() {
                super.release();
                locked.set(Boolean.FALSE);
            }
        };
        final AutoCloseableLock readLock = new AutoCloseableLock(readWriteLock.readLock());
        try (AutoCloseableLock lock = writeLock.acquire();){
            Thread competingWriteThread = new Thread(){

                @Override
                public void run() {
                    Assert.assertFalse((boolean)writeLock.tryLock());
                }
            };
            competingWriteThread.start();
            competingWriteThread.join();
            Thread competingReadThread = new Thread(){

                @Override
                public void run() {
                    Assert.assertFalse((boolean)readLock.tryLock());
                }
            };
            competingReadThread.start();
            competingReadThread.join();
        }
        Assert.assertFalse((boolean)((Boolean)locked.get()));
        locked.remove();
    }

    @Test(timeout=10000L)
    public void testReadLock() throws Exception {
        String testname = this.name.getMethodName();
        InstrumentedReadWriteLock readWriteLock = new InstrumentedReadWriteLock(true, testname, LOG, 2000L, 300L);
        final AutoCloseableLock readLock = new AutoCloseableLock(readWriteLock.readLock());
        final AutoCloseableLock writeLock = new AutoCloseableLock(readWriteLock.writeLock());
        try (AutoCloseableLock lock = readLock.acquire();){
            Thread competingReadThread = new Thread(){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)readLock.tryLock());
                    readLock.release();
                }
            };
            competingReadThread.start();
            competingReadThread.join();
            Thread competingWriteThread = new Thread(){

                @Override
                public void run() {
                    Assert.assertFalse((boolean)writeLock.tryLock());
                }
            };
            competingWriteThread.start();
            competingWriteThread.join();
        }
    }

    @Test(timeout=10000L)
    public void testReadLockLongHoldingReport() throws Exception {
        String testname = this.name.getMethodName();
        final AtomicLong time = new AtomicLong(0L);
        Timer mclock = new Timer(){

            public long monotonicNow() {
                return time.get();
            }
        };
        final AtomicLong wlogged = new AtomicLong(0L);
        final AtomicLong wsuppresed = new AtomicLong(0L);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        InstrumentedReadLock readLock = new InstrumentedReadLock(testname, LOG, readWriteLock, 2000L, 300L, mclock){

            protected void logWarning(long lockHeldTime, long suppressed) {
                wlogged.incrementAndGet();
                wsuppresed.set(suppressed);
            }
        };
        readLock.lock();
        time.set(100L);
        readLock.unlock();
        Assert.assertEquals((long)0L, (long)wlogged.get());
        Assert.assertEquals((long)0L, (long)wsuppresed.get());
        readLock.lock();
        time.set(500L);
        readLock.unlock();
        Assert.assertEquals((long)1L, (long)wlogged.get());
        Assert.assertEquals((long)0L, (long)wsuppresed.get());
        readLock.lock();
        time.set(900L);
        readLock.unlock();
        Assert.assertEquals((long)1L, (long)wlogged.get());
        Assert.assertEquals((long)0L, (long)wsuppresed.get());
        readLock.lock();
        time.set(3000L);
        readLock.unlock();
        Assert.assertEquals((long)2L, (long)wlogged.get());
        Assert.assertEquals((long)1L, (long)wsuppresed.get());
    }

    @Test(timeout=10000L)
    public void testWriteLockLongHoldingReport() throws Exception {
        String testname = this.name.getMethodName();
        final AtomicLong time = new AtomicLong(0L);
        Timer mclock = new Timer(){

            public long monotonicNow() {
                return time.get();
            }
        };
        final AtomicLong wlogged = new AtomicLong(0L);
        final AtomicLong wsuppresed = new AtomicLong(0L);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        InstrumentedWriteLock writeLock = new InstrumentedWriteLock(testname, LOG, readWriteLock, 2000L, 300L, mclock){

            protected void logWarning(long lockHeldTime, long suppressed) {
                wlogged.incrementAndGet();
                wsuppresed.set(suppressed);
            }
        };
        writeLock.lock();
        time.set(100L);
        writeLock.unlock();
        Assert.assertEquals((long)0L, (long)wlogged.get());
        Assert.assertEquals((long)0L, (long)wsuppresed.get());
        writeLock.lock();
        time.set(500L);
        writeLock.unlock();
        Assert.assertEquals((long)1L, (long)wlogged.get());
        Assert.assertEquals((long)0L, (long)wsuppresed.get());
        writeLock.lock();
        time.set(900L);
        writeLock.unlock();
        Assert.assertEquals((long)1L, (long)wlogged.get());
        Assert.assertEquals((long)0L, (long)wsuppresed.get());
        writeLock.lock();
        time.set(3000L);
        writeLock.unlock();
        Assert.assertEquals((long)2L, (long)wlogged.get());
        Assert.assertEquals((long)1L, (long)wsuppresed.get());
    }
}

