/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.HostsFileReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHostsFileReader {
    final String HOSTS_TEST_DIR = GenericTestUtils.getTestDir().getAbsolutePath();
    File EXCLUDES_FILE = new File(this.HOSTS_TEST_DIR, "dfs.exclude");
    File INCLUDES_FILE = new File(this.HOSTS_TEST_DIR, "dfs.include");
    String excludesFile = this.HOSTS_TEST_DIR + "/dfs.exclude";
    String includesFile = this.HOSTS_TEST_DIR + "/dfs.include";
    private String excludesXmlFile = this.HOSTS_TEST_DIR + "/dfs.exclude.xml";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        this.EXCLUDES_FILE.delete();
        this.INCLUDES_FILE.delete();
    }

    @Test
    public void testHostsFileReader() throws Exception {
        FileWriter efw = new FileWriter(this.excludesFile);
        FileWriter ifw = new FileWriter(this.includesFile);
        efw.write("#DFS-Hosts-excluded\n");
        efw.write("somehost1\n");
        efw.write("#This-is-comment\n");
        efw.write("somehost2\n");
        efw.write("somehost3 # host3\n");
        efw.write("somehost4\n");
        efw.write("somehost4 somehost5\n");
        efw.close();
        ifw.write("#Hosts-in-DFS\n");
        ifw.write("somehost1\n");
        ifw.write("somehost2\n");
        ifw.write("somehost3\n");
        ifw.write("#This-is-comment\n");
        ifw.write("somehost4 # host4\n");
        ifw.write("somehost4 somehost5\n");
        ifw.close();
        HostsFileReader hfp = new HostsFileReader(this.includesFile, this.excludesFile);
        int includesLen = hfp.getHosts().size();
        int excludesLen = hfp.getExcludedHosts().size();
        Assert.assertEquals((long)5L, (long)includesLen);
        Assert.assertEquals((long)5L, (long)excludesLen);
        Assert.assertTrue((boolean)hfp.getHosts().contains("somehost5"));
        Assert.assertFalse((boolean)hfp.getHosts().contains("host3"));
        Assert.assertTrue((boolean)hfp.getExcludedHosts().contains("somehost5"));
        Assert.assertFalse((boolean)hfp.getExcludedHosts().contains("host4"));
        String newExcludesFile = this.HOSTS_TEST_DIR + "/dfs1.exclude";
        String newIncludesFile = this.HOSTS_TEST_DIR + "/dfs1.include";
        efw = new FileWriter(newExcludesFile);
        ifw = new FileWriter(newIncludesFile);
        efw.write("#DFS-Hosts-excluded\n");
        efw.write("node1\n");
        efw.close();
        ifw.write("#Hosts-in-DFS\n");
        ifw.write("node2\n");
        ifw.close();
        hfp.refresh(newIncludesFile, newExcludesFile);
        Assert.assertTrue((boolean)hfp.getExcludedHosts().contains("node1"));
        Assert.assertTrue((boolean)hfp.getHosts().contains("node2"));
        HashSet hostsList = new HashSet();
        HashSet excludeList = new HashSet();
        hfp.getHostDetails(hostsList, excludeList);
        Assert.assertTrue((boolean)excludeList.contains("node1"));
        Assert.assertTrue((boolean)hostsList.contains("node2"));
    }

    @Test
    public void testCreateHostFileReaderWithNonexistentFile() throws Exception {
        try {
            new HostsFileReader(this.HOSTS_TEST_DIR + "/doesnt-exist", this.HOSTS_TEST_DIR + "/doesnt-exist");
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRefreshHostFileReaderWithNonexistentFile() throws Exception {
        FileWriter efw = new FileWriter(this.excludesFile);
        FileWriter ifw = new FileWriter(this.includesFile);
        efw.close();
        ifw.close();
        HostsFileReader hfp = new HostsFileReader(this.includesFile, this.excludesFile);
        Assert.assertTrue((boolean)this.INCLUDES_FILE.delete());
        try {
            hfp.refresh();
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testHostFileReaderWithNull() throws Exception {
        FileWriter efw = new FileWriter(this.excludesFile);
        FileWriter ifw = new FileWriter(this.includesFile);
        efw.close();
        ifw.close();
        HostsFileReader hfp = new HostsFileReader(this.includesFile, this.excludesFile);
        int includesLen = hfp.getHosts().size();
        int excludesLen = hfp.getExcludedHosts().size();
        Assert.assertEquals((long)0L, (long)includesLen);
        Assert.assertEquals((long)0L, (long)excludesLen);
        Assert.assertFalse((boolean)hfp.getHosts().contains("somehost5"));
        Assert.assertFalse((boolean)hfp.getExcludedHosts().contains("somehost5"));
    }

    @Test
    public void testHostFileReaderWithCommentsOnly() throws Exception {
        FileWriter efw = new FileWriter(this.excludesFile);
        FileWriter ifw = new FileWriter(this.includesFile);
        efw.write("#DFS-Hosts-excluded\n");
        efw.close();
        ifw.write("#Hosts-in-DFS\n");
        ifw.close();
        HostsFileReader hfp = new HostsFileReader(this.includesFile, this.excludesFile);
        int includesLen = hfp.getHosts().size();
        int excludesLen = hfp.getExcludedHosts().size();
        Assert.assertEquals((long)0L, (long)includesLen);
        Assert.assertEquals((long)0L, (long)excludesLen);
        Assert.assertFalse((boolean)hfp.getHosts().contains("somehost5"));
        Assert.assertFalse((boolean)hfp.getExcludedHosts().contains("somehost5"));
    }

    @Test
    public void testHostFileReaderWithSpaces() throws Exception {
        FileWriter efw = new FileWriter(this.excludesFile);
        FileWriter ifw = new FileWriter(this.includesFile);
        efw.write("#DFS-Hosts-excluded\n");
        efw.write("   somehost somehost2");
        efw.write("   somehost3 # somehost4");
        efw.close();
        ifw.write("#Hosts-in-DFS\n");
        ifw.write("   somehost somehost2");
        ifw.write("   somehost3 # somehost4");
        ifw.close();
        HostsFileReader hfp = new HostsFileReader(this.includesFile, this.excludesFile);
        int includesLen = hfp.getHosts().size();
        int excludesLen = hfp.getExcludedHosts().size();
        Assert.assertEquals((long)3L, (long)includesLen);
        Assert.assertEquals((long)3L, (long)excludesLen);
        Assert.assertTrue((boolean)hfp.getHosts().contains("somehost3"));
        Assert.assertFalse((boolean)hfp.getHosts().contains("somehost5"));
        Assert.assertFalse((boolean)hfp.getHosts().contains("somehost4"));
        Assert.assertTrue((boolean)hfp.getExcludedHosts().contains("somehost3"));
        Assert.assertFalse((boolean)hfp.getExcludedHosts().contains("somehost5"));
        Assert.assertFalse((boolean)hfp.getExcludedHosts().contains("somehost4"));
    }

    @Test
    public void testHostFileReaderWithTabs() throws Exception {
        FileWriter efw = new FileWriter(this.excludesFile);
        FileWriter ifw = new FileWriter(this.includesFile);
        efw.write("#DFS-Hosts-excluded\n");
        efw.write("     \n");
        efw.write("   somehost \t somehost2 \n somehost4");
        efw.write("   somehost3 \t # somehost5");
        efw.close();
        ifw.write("#Hosts-in-DFS\n");
        ifw.write("     \n");
        ifw.write("   somehost \t  somehost2 \n somehost4");
        ifw.write("   somehost3 \t # somehost5");
        ifw.close();
        HostsFileReader hfp = new HostsFileReader(this.includesFile, this.excludesFile);
        int includesLen = hfp.getHosts().size();
        int excludesLen = hfp.getExcludedHosts().size();
        Assert.assertEquals((long)4L, (long)includesLen);
        Assert.assertEquals((long)4L, (long)excludesLen);
        Assert.assertTrue((boolean)hfp.getHosts().contains("somehost2"));
        Assert.assertFalse((boolean)hfp.getHosts().contains("somehost5"));
        Assert.assertTrue((boolean)hfp.getExcludedHosts().contains("somehost2"));
        Assert.assertFalse((boolean)hfp.getExcludedHosts().contains("somehost5"));
    }

    @Test
    public void testHostFileReaderWithTimeout() throws Exception {
        FileWriter efw = new FileWriter(this.excludesXmlFile);
        FileWriter ifw = new FileWriter(this.includesFile);
        efw.write("<?xml version=\"1.0\"?>\n");
        efw.write("<!-- yarn.nodes.exclude -->\n");
        efw.write("<hosts>\n");
        efw.write("<host><name>host1</name></host>\n");
        efw.write("<host><name>host2</name><timeout>123</timeout></host>\n");
        efw.write("<host><name>host3</name><timeout>-1</timeout></host>\n");
        efw.write("<host><name>10000</name></host>\n");
        efw.write("<host><name>10001</name><timeout>123</timeout></host>\n");
        efw.write("<host><name>10002</name><timeout>-1</timeout></host>\n");
        efw.write("<host><name>host4,host5, host6</name><timeout>1800</timeout></host>\n");
        efw.write("</hosts>\n");
        efw.close();
        ifw.write("#Hosts-in-DFS\n");
        ifw.write("     \n");
        ifw.write("   somehost \t  somehost2 \n somehost4");
        ifw.write("   somehost3 \t # somehost5");
        ifw.close();
        HostsFileReader hfp = new HostsFileReader(this.includesFile, this.excludesXmlFile);
        int includesLen = hfp.getHosts().size();
        int excludesLen = hfp.getExcludedHosts().size();
        Assert.assertEquals((long)4L, (long)includesLen);
        Assert.assertEquals((long)9L, (long)excludesLen);
        HashSet includes = new HashSet();
        HashMap excludes = new HashMap();
        hfp.getHostDetails(includes, excludes);
        Assert.assertTrue((boolean)excludes.containsKey("host1"));
        Assert.assertTrue((boolean)excludes.containsKey("host2"));
        Assert.assertTrue((boolean)excludes.containsKey("host3"));
        Assert.assertTrue((boolean)excludes.containsKey("10000"));
        Assert.assertTrue((boolean)excludes.containsKey("10001"));
        Assert.assertTrue((boolean)excludes.containsKey("10002"));
        Assert.assertTrue((boolean)excludes.containsKey("host4"));
        Assert.assertTrue((boolean)excludes.containsKey("host5"));
        Assert.assertTrue((boolean)excludes.containsKey("host6"));
        Assert.assertTrue((excludes.get("host1") == null ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)excludes.get("host2") == 123 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)excludes.get("host3") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((excludes.get("10000") == null ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)excludes.get("10001") == 123 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)excludes.get("10002") == -1 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)excludes.get("host4") == 1800 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)excludes.get("host5") == 1800 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)excludes.get("host6") == 1800 ? 1 : 0) != 0);
    }
}

