/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.RollingAverages;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.Time;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRollingAverages {
    @Test(timeout=30000L)
    public void testRollingAveragesEmptyRollover() throws Exception {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        try (RollingAverages rollingAverages = new RollingAverages(5, 2);){
            rollingAverages.snapshot(rb, true);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.never())).addGauge(Interns.info((String)"FooRollingAvgTime", (String)"Rolling average time for foo"), 0L);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.never())).addGauge(Interns.info((String)"BarAvgTime", (String)"Rolling average time for bar"), 0L);
            Thread.sleep(6000L);
            rollingAverages.snapshot(rb, false);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.never())).addGauge(Interns.info((String)"FooRollingAvgTime", (String)"Rolling average time for foo"), 0L);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.never())).addGauge(Interns.info((String)"BarAvgTime", (String)"Rolling average time for bar"), 0L);
        }
    }

    @Test(timeout=30000L)
    public void testRollingAveragesRollover() throws Exception {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        String name = "foo2";
        int windowSize = 5;
        int numWindows = 2;
        int numOpsPerIteration = 1000;
        try (RollingAverages rollingAverages = new RollingAverages(5, 2);){
            long start = Time.monotonicNow();
            for (int i = 1; i <= 3; ++i) {
                for (long j = 1L; j <= 1000L; ++j) {
                    rollingAverages.add("foo2", (long)i);
                }
                long sleep = start + (long)(5000 * i) + 1000L - Time.monotonicNow();
                Thread.sleep(sleep);
                rollingAverages.snapshot(rb, false);
                double rollingSum = 1000 * (i > 1 ? i - 1 : 0) + 1000 * i;
                long rollingTotal = i > 1 ? 2000L : 1000L;
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"Foo2RollingAvgTime", (String)"Rolling average time for foo2"), rollingSum / (double)rollingTotal);
                ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.times((int)i))).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"Foo2RollingAvgTime", (String)"Rolling average time for foo2")), Matchers.anyDouble());
            }
        }
    }
}

