/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRawLocalFileSystemContract
extends FileSystemContractBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestRawLocalFileSystemContract.class);

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)conf).getRawFileSystem();
    }

    @Override
    protected boolean renameSupported() {
        return false;
    }

    @Override
    public String getDefaultWorkingDirectory() {
        return this.fs.getWorkingDirectory().toUri().getPath();
    }

    @Override
    protected Path path(String pathString) {
        if (pathString.equals(this.getDefaultWorkingDirectory()) || pathString.equals(".") || pathString.equals("..")) {
            return super.path(pathString);
        }
        return new Path(GenericTestUtils.getTempPath(pathString)).makeQualified(this.fs.getUri(), this.fs.getWorkingDirectory());
    }

    @Override
    protected boolean filesystemIsCaseSensitive() {
        return !Shell.WINDOWS && !Shell.MAC;
    }
}

