/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.re2j.PatternSyntaxException;
import org.apache.hadoop.fs.GlobPattern;
import org.junit.Assert;
import org.junit.Test;

public class TestGlobPattern {
    private void assertMatch(boolean yes, String glob, String ... input) {
        GlobPattern pattern = new GlobPattern(glob);
        for (String s : input) {
            boolean result = pattern.matches((CharSequence)s);
            Assert.assertTrue((String)(glob + " should" + (yes ? "" : " not") + " match " + s), (boolean)(yes ? result : !result));
        }
    }

    private void shouldThrow(String ... globs) {
        for (String glob : globs) {
            try {
                GlobPattern.compile((String)glob);
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
                continue;
            }
            Assert.assertTrue((String)("glob " + glob + " should throw"), (boolean)false);
        }
    }

    @Test
    public void testValidPatterns() {
        this.assertMatch(true, "*", "^$", "foo", "bar", "\n");
        this.assertMatch(true, "?", "?", "^", "[", "]", "$");
        this.assertMatch(true, "foo*", "foo", "food", "fool", "foo\n", "foo\nbar");
        this.assertMatch(true, "f*d", "fud", "food", "foo\nd");
        this.assertMatch(true, "*d", "good", "bad", "\nd");
        this.assertMatch(true, "\\*\\?\\[\\{\\\\", "*?[{\\");
        this.assertMatch(true, "[]^-]", "]", "-", "^");
        this.assertMatch(true, "]", "]");
        this.assertMatch(true, "^.$()|+", "^.$()|+");
        this.assertMatch(true, "[^^]", ".", "$", "[", "]");
        this.assertMatch(false, "[^^]", "^");
        this.assertMatch(true, "[!!-]", "^", "?");
        this.assertMatch(false, "[!!-]", "!", "-");
        this.assertMatch(true, "{[12]*,[45]*,[78]*}", "1", "2!", "4", "42", "7", "7$");
        this.assertMatch(false, "{[12]*,[45]*,[78]*}", "3", "6", "9\u00df");
        this.assertMatch(true, "}", "}");
    }

    @Test
    public void testInvalidPatterns() {
        this.shouldThrow("[", "[[]]", "{", "\\");
    }

    @Test(timeout=1000L)
    public void testPathologicalPatterns() {
        String badFilename = "job_1429571161900_4222-1430338332599-tda%2D%2D+******************************+++...%270%27%28Stage-1430338580443-39-2000-SUCCEEDED-production%2Dhigh-1430338340360.jhist";
        this.assertMatch(true, badFilename, badFilename);
    }
}

