/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.fusesource.leveldbjni.internal;

import org.apache.hadoop.shaded.org.fusesource.hawtjni.runtime.ClassFlag;
import org.apache.hadoop.shaded.org.fusesource.hawtjni.runtime.JniClass;
import org.apache.hadoop.shaded.org.fusesource.hawtjni.runtime.JniMethod;
import org.apache.hadoop.shaded.org.fusesource.hawtjni.runtime.MethodFlag;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.internal.NativeDB;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.internal.NativeObject;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.internal.NativeStdString;

class NativeStatus
extends NativeObject {
    public NativeStatus(long self) {
        super(self);
    }

    public void delete() {
        this.assertAllocated();
        StatusJNI.delete(this.self);
        this.self = 0L;
    }

    public boolean isOk() {
        this.assertAllocated();
        return StatusJNI.ok(this.self);
    }

    public boolean isNotFound() {
        this.assertAllocated();
        return StatusJNI.IsNotFound(this.self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.assertAllocated();
        long strptr = StatusJNI.ToString(this.self);
        if (strptr == 0L) {
            return null;
        }
        NativeStdString rc = new NativeStdString(strptr);
        try {
            String string = rc.toString();
            return string;
        }
        finally {
            rc.delete();
        }
    }

    @JniClass(name="leveldb::Status", flags={ClassFlag.CPP})
    static class StatusJNI {
        StatusJNI() {
        }

        @JniMethod(flags={MethodFlag.CPP_DELETE})
        public static final native void delete(long var0);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        public static final native boolean ok(long var0);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        public static final native boolean IsNotFound(long var0);

        @JniMethod(copy="std::string", flags={MethodFlag.CPP_METHOD})
        public static final native long ToString(long var0);

        static {
            NativeDB.LIBRARY.load();
        }
    }
}

