/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.util;

import java.io.IOException;
import java.io.InputStream;

public class ReadLine {
    final InputStream in;
    final byte[] bytes = new byte[8192];
    int pos = 0;
    int avail = 0;

    public ReadLine(InputStream in) {
        this.in = in;
    }

    public String next() throws IOException {
        return this.next(1);
    }

    public String next(int lines) throws IOException {
        if (lines < 1) {
            lines = 1;
        }
        StringBuffer buf = new StringBuffer(128 * lines);
        if (this.avail <= 0 || this.pos >= this.avail) {
            this.pos = 0;
            this.avail = this.in.read(this.bytes);
        }
        while (this.avail >= 0) {
            block4: while (this.pos < this.avail) {
                char c = (char)this.bytes[this.pos++];
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (--lines >= 1 || buf.length() <= 0) continue block4;
                        return buf.toString();
                    }
                }
                buf.append(c);
            }
            this.pos = 0;
            this.avail = this.in.read(this.bytes);
        }
        return buf.length() > 0 ? buf.toString() : null;
    }

    public byte[] nextAsBytes() throws IOException {
        return this.nextAsBytes(1);
    }

    public byte[] nextAsBytes(int lines) throws IOException {
        if (lines < 1) {
            lines = 1;
        }
        byte[] buf = new byte[8192];
        int bufPos = 0;
        if (this.avail <= 0 || this.pos >= this.avail) {
            this.pos = 0;
            this.avail = this.in.read(this.bytes);
        }
        while (this.avail >= 0) {
            block4: while (this.pos < this.avail) {
                byte b = this.bytes[this.pos++];
                switch (b) {
                    case 10: 
                    case 13: {
                        if (--lines != 0 || bufPos <= 0) continue block4;
                        return buf;
                    }
                }
                if (bufPos >= buf.length) {
                    byte[] moreBuff = new byte[buf.length * 2];
                    System.arraycopy(buf, 0, moreBuff, 0, buf.length);
                    buf = moreBuff;
                }
                buf[bufPos++] = b;
            }
            this.pos = 0;
            this.avail = this.in.read(this.bytes);
        }
        return (byte[])(bufPos > 0 ? buf : null);
    }
}

