/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.AbstractKrbTransport;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.KrbTransport;

public class KrbTcpTransport
extends AbstractKrbTransport
implements KrbTransport {
    private Socket socket;
    private DataOutputStream outputStream;
    private DataInputStream inputStream;
    private byte[] messageBuffer;

    public KrbTcpTransport(Socket socket) throws IOException {
        this.socket = socket;
        this.outputStream = new DataOutputStream(socket.getOutputStream());
        this.inputStream = new DataInputStream(socket.getInputStream());
        this.messageBuffer = new byte[0x100000];
    }

    @Override
    public void sendMessage(ByteBuffer message) throws IOException {
        this.outputStream.write(message.array());
    }

    @Override
    public ByteBuffer receiveMessage() throws IOException {
        int msgLen = this.inputStream.readInt();
        if (msgLen > 0) {
            this.inputStream.readFully(this.messageBuffer, 0, msgLen);
            return ByteBuffer.wrap(this.messageBuffer, 0, msgLen);
        }
        return null;
    }

    @Override
    public boolean isTcp() {
        return true;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public void release() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

