/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.preauth.token;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbRuntime;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.PrivateKeyReader;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.PublicKeyReader;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.preauth.PluginRequestContext;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.preauth.token.TokenPreauthMeta;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.preauth.AbstractPreauthPlugin;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.request.AsRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.request.TgsRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KrbToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.token.PaTokenRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.token.TokenInfo;

public class TokenPreauth
extends AbstractPreauthPlugin {
    public TokenPreauth() {
        super(new TokenPreauthMeta());
    }

    @Override
    public boolean verify(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataEntry paData) throws KrbException {
        if (!kdcRequest.getKdcContext().getConfig().isAllowTokenPreauth()) {
            throw new KrbException("Token preauth is not allowed.");
        }
        if (paData.getPaDataType() == PaDataType.TOKEN_REQUEST) {
            EncryptedData encData = KrbCodec.decode(paData.getPaDataValue(), EncryptedData.class);
            EncryptionKey clientKey = kdcRequest.getArmorKey();
            kdcRequest.setClientKey(clientKey);
            PaTokenRequest paTokenRequest = EncryptionUtil.unseal(encData, clientKey, KeyUsage.PA_TOKEN, PaTokenRequest.class);
            KrbToken token = paTokenRequest.getToken();
            List<String> issuers = kdcRequest.getKdcContext().getConfig().getIssuers();
            TokenInfo tokenInfo = paTokenRequest.getTokenInfo();
            String issuer = tokenInfo.getTokenVendor();
            if (!issuers.contains(issuer)) {
                throw new KrbException("Unconfigured issuer: " + issuer);
            }
            TokenDecoder tokenDecoder = KrbRuntime.getTokenProvider().createTokenDecoder();
            this.configureKeys(tokenDecoder, kdcRequest, issuer);
            AuthToken authToken = null;
            try {
                authToken = tokenDecoder.decodeFromBytes(token.getTokenValue());
                if (!tokenDecoder.isSigned()) {
                    throw new KrbException("Token should be signed.");
                }
            }
            catch (IOException e) {
                throw new KrbException("Decoding failed", (Throwable)e);
            }
            if (authToken == null) {
                throw new KrbException("Token Decoding failed");
            }
            List<String> audiences = authToken.getAudiences();
            PrincipalName serverPrincipal = kdcRequest.getKdcReq().getReqBody().getSname();
            serverPrincipal.setRealm(kdcRequest.getKdcReq().getReqBody().getRealm());
            kdcRequest.setServerPrincipal(serverPrincipal);
            if (!audiences.contains(serverPrincipal.getName())) {
                throw new KrbException("The token audience does not match with the target server principal!");
            }
            if (kdcRequest instanceof AsRequest) {
                AsRequest asRequest = (AsRequest)kdcRequest;
                asRequest.setToken(authToken);
            } else if (kdcRequest instanceof TgsRequest) {
                TgsRequest tgsRequest = (TgsRequest)kdcRequest;
                tgsRequest.setToken(authToken);
            }
            return true;
        }
        return false;
    }

    private void configureKeys(TokenDecoder tokenDecoder, KdcRequest kdcRequest, String issuer) {
        File decryptionKeyFile;
        String decryptionKeyPath;
        File verifyKeyFile;
        String verifyKeyPath = kdcRequest.getKdcContext().getConfig().getVerifyKeyConfig();
        if (verifyKeyPath != null && (verifyKeyFile = this.getKeyFile(verifyKeyPath, issuer)) != null) {
            PublicKey verifyKey = null;
            try {
                FileInputStream fis = new FileInputStream(verifyKeyFile);
                verifyKey = PublicKeyReader.loadPublicKey(fis);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tokenDecoder.setVerifyKey(verifyKey);
        }
        if ((decryptionKeyPath = kdcRequest.getKdcContext().getConfig().getDecryptionKeyConfig()) != null && (decryptionKeyFile = this.getKeyFile(decryptionKeyPath, issuer)) != null) {
            PrivateKey decryptionKey = null;
            try {
                FileInputStream fis = new FileInputStream(decryptionKeyFile);
                decryptionKey = PrivateKeyReader.loadPrivateKey(fis);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tokenDecoder.setDecryptionKey(decryptionKey);
        }
    }

    private File getKeyFile(String path, String issuer) {
        File file = new File(path);
        if (file.isDirectory()) {
            File[] listOfFiles = file.listFiles();
            File verifyKeyFile = null;
            if (listOfFiles == null) {
                throw new RuntimeException("List of files is null.");
            }
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile() || !listOfFiles[i].getName().contains(issuer)) continue;
                verifyKeyFile = listOfFiles[i];
                break;
            }
            return verifyKeyFile;
        }
        if (file.isFile()) {
            return file;
        }
        return null;
    }
}

