/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.LocalKadmin;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.LocalKadminImpl;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.Krb5Conf;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbPkinitClient;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbTokenClient;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.KdcServer;
import org.apache.hadoop.shaded.org.apache.kerby.util.NetworkUtil;

public class SimpleKdcServer
extends KdcServer {
    private final KrbClient krbClnt = new KrbClient();
    private LocalKadmin kadmin;
    private Krb5Conf krb5Conf;
    private File workDir;
    private KrbPkinitClient pkinitClient;
    private KrbTokenClient tokenClient;

    public SimpleKdcServer() throws KrbException {
        this.setKdcRealm("EXAMPLE.COM");
        this.setKdcHost("localhost");
        this.setKdcPort(NetworkUtil.getServerPort());
    }

    @Override
    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    @Override
    public void setKdcRealm(String realm) {
        super.setKdcRealm(realm);
        this.krbClnt.setKdcRealm(realm);
    }

    @Override
    public void setKdcHost(String kdcHost) {
        super.setKdcHost(kdcHost);
        this.krbClnt.setKdcHost(kdcHost);
    }

    @Override
    public void setKdcTcpPort(int kdcTcpPort) {
        super.setKdcTcpPort(kdcTcpPort);
        this.krbClnt.setKdcTcpPort(kdcTcpPort);
        this.setAllowTcp(true);
    }

    @Override
    public void setAllowUdp(boolean allowUdp) {
        super.setAllowUdp(allowUdp);
        this.krbClnt.setAllowUdp(allowUdp);
    }

    @Override
    public void setAllowTcp(boolean allowTcp) {
        super.setAllowTcp(allowTcp);
        this.krbClnt.setAllowTcp(allowTcp);
    }

    @Override
    public void setKdcUdpPort(int kdcUdpPort) {
        super.setKdcUdpPort(kdcUdpPort);
        this.krbClnt.setKdcUdpPort(kdcUdpPort);
        this.setAllowUdp(true);
    }

    @Override
    public void init() throws KrbException {
        super.init();
        this.kadmin = new LocalKadminImpl(this.getKdcSetting(), this.getIdentityService());
        this.kadmin.createBuiltinPrincipals();
        try {
            this.krb5Conf = new Krb5Conf(this);
            this.krb5Conf.initKrb5conf();
        }
        catch (IOException e) {
            throw new KrbException("Failed to make krb5.conf", (Throwable)e);
        }
    }

    @Override
    public void start() throws KrbException {
        super.start();
        this.krbClnt.init();
    }

    public KrbClient getKrbClient() {
        return this.krbClnt;
    }

    public KrbPkinitClient getPkinitClient() {
        if (this.pkinitClient == null) {
            this.pkinitClient = new KrbPkinitClient(this.krbClnt);
        }
        return this.pkinitClient;
    }

    public KrbTokenClient getTokenClient() {
        if (this.tokenClient == null) {
            this.tokenClient = new KrbTokenClient(this.krbClnt);
        }
        return this.tokenClient;
    }

    public LocalKadmin getKadmin() {
        return this.kadmin;
    }

    public void createPrincipal(String principal) throws KrbException {
        this.kadmin.addPrincipal(principal);
    }

    public void createPrincipal(String principal, String password) throws KrbException {
        this.kadmin.addPrincipal(principal, password);
    }

    public void createPrincipals(String ... principals) throws KrbException {
        for (String principal : principals) {
            this.kadmin.addPrincipal(principal);
        }
    }

    public void createAndExportPrincipals(File keytabFile, String ... principals) throws KrbException {
        this.createPrincipals(principals);
        this.exportPrincipals(keytabFile);
    }

    public void deletePrincipals(String ... principals) throws KrbException {
        for (String principal : principals) {
            this.deletePrincipal(principal);
        }
    }

    public void deletePrincipal(String principal) throws KrbException {
        this.kadmin.deletePrincipal(principal);
    }

    public void exportPrincipals(File keytabFile) throws KrbException {
        this.kadmin.exportKeytab(keytabFile);
    }

    public void exportPrincipal(String principal, File keytabFile) throws KrbException {
        this.kadmin.exportKeytab(keytabFile, principal);
    }

    @Override
    public void stop() throws KrbException {
        super.stop();
        try {
            this.krb5Conf.deleteKrb5conf();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

