/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.preauth.pkinit;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;

public class CertificateHelper {
    public static List<Certificate> loadCerts(String filename) throws KrbException {
        FileInputStream res = null;
        try {
            res = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return CertificateHelper.loadCerts(res);
    }

    public static List<Certificate> loadCerts(InputStream inputStream) throws KrbException {
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = certFactory.generateCertificates(inputStream);
            return new ArrayList<Certificate>(certs);
        }
        catch (CertificateException e) {
            throw new KrbException("Failed to load certificates", (Throwable)e);
        }
    }
}

