/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.token;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.kerby.KOption;
import org.apache.hadoop.shaded.org.apache.kerby.KOptions;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbContext;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.TokenOption;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.AbstractPreauthPlugin;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.token.TokenContext;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.token.TokenRequestContext;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.preauth.PaFlag;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.preauth.PaFlags;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.preauth.PluginRequestContext;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.preauth.token.TokenPreauthMeta;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KrbToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaData;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.token.PaTokenRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.token.TokenInfo;

public class TokenPreauth
extends AbstractPreauthPlugin {
    private TokenContext tokenContext;

    public TokenPreauth() {
        super(new TokenPreauthMeta());
    }

    @Override
    public void init(KrbContext context) {
        super.init(context);
        this.tokenContext = new TokenContext();
    }

    @Override
    public PluginRequestContext initRequestContext(KdcRequest kdcRequest) {
        TokenRequestContext reqCtx = new TokenRequestContext();
        return reqCtx;
    }

    @Override
    public void prepareQuestions(KdcRequest kdcRequest, PluginRequestContext requestContext) {
    }

    @Override
    public List<EncryptionType> getEncTypes(KdcRequest kdcRequest, PluginRequestContext requestContext) {
        return Collections.emptyList();
    }

    @Override
    public void setPreauthOptions(KdcRequest kdcRequest, PluginRequestContext requestContext, KOptions options) {
        this.tokenContext.usingIdToken = options.getBooleanOption(TokenOption.USE_TOKEN, false);
        if (this.tokenContext.usingIdToken) {
            if (options.contains(TokenOption.USER_ID_TOKEN)) {
                this.tokenContext.token = (AuthToken)options.getOptionValue(TokenOption.USER_ID_TOKEN);
            }
        } else if (options.contains(TokenOption.USER_AC_TOKEN)) {
            this.tokenContext.token = (AuthToken)options.getOptionValue(TokenOption.USER_AC_TOKEN);
        }
    }

    @Override
    public void tryFirst(KdcRequest kdcRequest, PluginRequestContext requestContext, PaData outPadata) throws KrbException {
        if (kdcRequest.getAsKey() == null) {
            kdcRequest.needAsKey();
        }
        outPadata.addElement(this.makeEntry(kdcRequest));
    }

    @Override
    public boolean process(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataEntry inPadata, PaData outPadata) throws KrbException {
        if (kdcRequest.getAsKey() == null) {
            kdcRequest.needAsKey();
        }
        outPadata.addElement(this.makeEntry(kdcRequest));
        return true;
    }

    @Override
    public boolean tryAgain(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataType preauthType, PaData errPadata, PaData outPadata) {
        return false;
    }

    @Override
    public PaFlags getFlags(PaDataType paType) {
        PaFlags paFlags = new PaFlags(0);
        paFlags.setFlag(PaFlag.PA_REAL);
        return paFlags;
    }

    private PaDataEntry makeEntry(KdcRequest kdcRequest) throws KrbException {
        AuthToken authToken;
        KOptions options = kdcRequest.getPreauthOptions();
        KOption idToken = options.getOption(TokenOption.USER_ID_TOKEN);
        KOption acToken = options.getOption(TokenOption.USER_AC_TOKEN);
        if (idToken != null) {
            authToken = (AuthToken)idToken.getOptionInfo().getValue();
        } else if (acToken != null) {
            authToken = (AuthToken)acToken.getOptionInfo().getValue();
        } else {
            throw new KrbException("missing token.");
        }
        PaTokenRequest tokenPa = new PaTokenRequest();
        tokenPa.setToken((KrbToken)authToken);
        TokenInfo info = new TokenInfo();
        info.setTokenVendor(authToken.getIssuer());
        tokenPa.setTokenInfo(info);
        EncryptedData paDataValue = EncryptionUtil.seal(tokenPa, kdcRequest.getAsKey(), KeyUsage.PA_TOKEN);
        PaDataEntry paDataEntry = new PaDataEntry();
        paDataEntry.setPaDataType(PaDataType.TOKEN_REQUEST);
        paDataEntry.setPaDataValue(KrbCodec.encode(paDataValue));
        return paDataEntry;
    }
}

