/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbSetting;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.TransportPair;

public final class ClientUtil {
    private static final String KRB5_FILE_NAME = "krb5.conf";
    private static final String KRB5_ENV_NAME = "KRB5_CONFIG";

    private ClientUtil() {
    }

    public static KrbConfig getConfig(File confDir) throws KrbException {
        File confFile = new File(confDir, KRB5_FILE_NAME);
        if (!confFile.exists()) {
            throw new KrbException("krb5.conf not found");
        }
        if (confFile != null && confFile.exists()) {
            KrbConfig krbConfig = new KrbConfig();
            try {
                krbConfig.addKrb5Config(confFile);
                return krbConfig;
            }
            catch (IOException e) {
                throw new KrbException("Failed to load krb config " + confFile.getAbsolutePath());
            }
        }
        return null;
    }

    public static KrbConfig getDefaultConfig() throws KrbException {
        String tmpEnv;
        File confFile = null;
        try {
            Map<String, String> mapEnv = System.getenv();
            tmpEnv = mapEnv.get(KRB5_ENV_NAME);
        }
        catch (SecurityException e) {
            tmpEnv = null;
        }
        if (tmpEnv != null) {
            confFile = new File(tmpEnv);
            if (!confFile.exists()) {
                throw new KrbException("krb5 conf not found. Invalid env KRB5_CONFIG");
            }
        } else {
            File confDir = new File("/etc/");
            if (confDir.exists()) {
                confFile = new File(confDir, KRB5_FILE_NAME);
            }
        }
        KrbConfig krbConfig = new KrbConfig();
        if (confFile != null && confFile.exists()) {
            try {
                krbConfig.addKrb5Config(confFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to load krb config " + confFile.getAbsolutePath());
            }
        }
        return krbConfig;
    }

    public static TransportPair getTransportPair(KrbSetting setting) throws KrbException {
        int udpPort;
        TransportPair result = new TransportPair();
        int tcpPort = setting.checkGetKdcTcpPort();
        if (tcpPort > 0) {
            result.tcpAddress = new InetSocketAddress(setting.getKdcHost(), tcpPort);
        }
        if ((udpPort = setting.checkGetKdcUdpPort()) > 0) {
            result.udpAddress = new InetSocketAddress(setting.getKdcHost(), udpPort);
        }
        return result;
    }
}

