/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.asn1.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.Tag;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.TaggingOption;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.UniversalTag;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.parse.Asn1DerivedItem;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.type.Asn1Object;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.type.Asn1Type;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.util.Asn1Util;

public abstract class Asn1Encodeable
extends Asn1Object
implements Asn1Type {
    private int bodyLength = -1;
    private Asn1Type.EncodingType encodingType = Asn1Type.EncodingType.BER;
    private boolean isImplicit = true;
    private boolean isDefinitiveLength = true;

    public Asn1Encodeable(Tag tag) {
        super(tag);
    }

    public Asn1Encodeable(UniversalTag tag) {
        super(tag);
    }

    public Asn1Encodeable(int tag) {
        super(tag);
    }

    @Override
    public void usePrimitive(boolean isPrimitive) {
        this.tag().usePrimitive(isPrimitive);
    }

    @Override
    public boolean isPrimitive() {
        return this.tag().isPrimitive();
    }

    @Override
    public void useDefinitiveLength(boolean isDefinitiveLength) {
        this.isDefinitiveLength = isDefinitiveLength;
    }

    @Override
    public boolean isDefinitiveLength() {
        return this.isDefinitiveLength;
    }

    @Override
    public void useImplicit(boolean isImplicit) {
        this.isImplicit = isImplicit;
    }

    @Override
    public boolean isImplicit() {
        return this.isImplicit;
    }

    @Override
    public void useDER() {
        this.encodingType = Asn1Type.EncodingType.DER;
    }

    @Override
    public boolean isDER() {
        return this.encodingType == Asn1Type.EncodingType.DER;
    }

    @Override
    public void useBER() {
        this.encodingType = Asn1Type.EncodingType.BER;
    }

    @Override
    public boolean isBER() {
        return this.encodingType == Asn1Type.EncodingType.BER;
    }

    @Override
    public void useCER() {
        this.encodingType = Asn1Type.EncodingType.CER;
    }

    @Override
    public boolean isCER() {
        return this.encodingType == Asn1Type.EncodingType.CER;
    }

    @Override
    public byte[] encode() throws IOException {
        int len = this.encodingLength();
        ByteBuffer byteBuffer = ByteBuffer.allocate(len);
        this.encode(byteBuffer);
        byteBuffer.flip();
        return byteBuffer.array();
    }

    @Override
    public void encode(ByteBuffer buffer) throws IOException {
        Asn1Util.encodeTag(buffer, this.tag());
        int bodyLen = this.getBodyLength();
        Asn1Util.encodeLength(buffer, bodyLen);
        this.encodeBody(buffer);
    }

    protected void encodeBody(ByteBuffer buffer) throws IOException {
    }

    @Override
    public void decode(byte[] content) throws IOException {
        this.decode(ByteBuffer.wrap(content));
    }

    @Override
    public int encodingLength() {
        return this.getHeaderLength() + this.getBodyLength();
    }

    @Override
    protected int getHeaderLength() {
        try {
            return this.encodingHeaderLength();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int getBodyLength() {
        if (this.bodyLength == -1) {
            try {
                this.bodyLength = this.encodingBodyLength();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.bodyLength == -1) {
                throw new RuntimeException("Unexpected body length: -1");
            }
        }
        return this.bodyLength;
    }

    protected int encodingHeaderLength() throws IOException {
        int headerLen = Asn1Util.lengthOfTagLength(this.tagNo());
        int bodyLen = this.getBodyLength();
        return headerLen += Asn1Util.lengthOfBodyLength(bodyLen);
    }

    protected abstract int encodingBodyLength() throws IOException;

    @Override
    public void decode(ByteBuffer content) throws IOException {
        Asn1ParseResult parseResult = Asn1Parser.parse(content);
        this.decode(parseResult);
    }

    public void decode(Asn1ParseResult parseResult) throws IOException {
        Asn1ParseResult tmpParseResult = parseResult;
        if (!this.tag().equals(parseResult.tag())) {
            if (this.isPrimitive() && !parseResult.isPrimitive()) {
                Asn1Container container = (Asn1Container)parseResult;
                tmpParseResult = new Asn1DerivedItem(this.tag(), container);
            } else {
                throw new IOException("Unexpected item " + parseResult.simpleInfo() + ", expecting " + this.tag());
            }
        }
        this.decodeBody(tmpParseResult);
    }

    protected abstract void decodeBody(Asn1ParseResult var1) throws IOException;

    protected int taggedEncodingLength(TaggingOption taggingOption) {
        int taggingTagNo = taggingOption.getTagNo();
        int taggingBodyLen = taggingOption.isImplicit() ? this.getBodyLength() : this.encodingLength();
        int taggingEncodingLen = Asn1Util.lengthOfTagLength(taggingTagNo) + Asn1Util.lengthOfBodyLength(taggingBodyLen) + taggingBodyLen;
        return taggingEncodingLen;
    }

    @Override
    public byte[] taggedEncode(TaggingOption taggingOption) throws IOException {
        int len = this.taggedEncodingLength(taggingOption);
        ByteBuffer byteBuffer = ByteBuffer.allocate(len);
        this.taggedEncode(byteBuffer, taggingOption);
        byteBuffer.flip();
        return byteBuffer.array();
    }

    @Override
    public void taggedEncode(ByteBuffer buffer, TaggingOption taggingOption) throws IOException {
        Tag taggingTag = taggingOption.getTag(!this.isPrimitive());
        Asn1Util.encodeTag(buffer, taggingTag);
        int taggingBodyLen = taggingOption.isImplicit() ? this.encodingBodyLength() : this.encodingLength();
        Asn1Util.encodeLength(buffer, taggingBodyLen);
        if (taggingOption.isImplicit()) {
            this.encodeBody(buffer);
        } else {
            this.encode(buffer);
        }
    }

    @Override
    public void taggedDecode(byte[] content, TaggingOption taggingOption) throws IOException {
        this.taggedDecode(ByteBuffer.wrap(content), taggingOption);
    }

    @Override
    public void taggedDecode(ByteBuffer content, TaggingOption taggingOption) throws IOException {
        Asn1ParseResult parseResult = Asn1Parser.parse(content);
        this.taggedDecode(parseResult, taggingOption);
    }

    public void taggedDecode(Asn1ParseResult parseResult, TaggingOption taggingOption) throws IOException {
        Asn1Container container;
        Tag expectedTaggingTagFlags = taggingOption.getTag(!this.isPrimitive());
        Asn1ParseResult tmpParseResult = parseResult;
        if (!expectedTaggingTagFlags.equals(parseResult.tag())) {
            if (this.isPrimitive() && !parseResult.isPrimitive()) {
                container = (Asn1Container)parseResult;
                tmpParseResult = new Asn1DerivedItem(this.tag(), container);
            } else {
                throw new IOException("Unexpected tag " + parseResult.tag() + ", expecting " + expectedTaggingTagFlags);
            }
        }
        if (taggingOption.isImplicit()) {
            this.decodeBody(tmpParseResult);
        } else {
            container = (Asn1Container)parseResult;
            tmpParseResult = container.getChildren().get(0);
            this.decode(tmpParseResult);
        }
    }
}

