/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.kerby.KOption;
import org.apache.hadoop.shaded.org.apache.kerby.KOptionInfo;
import org.apache.hadoop.shaded.org.apache.kerby.KOptionType;

public class KOptions {
    private final Map<KOption, KOption> options = new HashMap<KOption, KOption>();

    public static boolean parseSetValue(KOptionInfo kopt, String strValue) {
        KOptionType kt = kopt.getType();
        if (kt == KOptionType.NOV) {
            return true;
        }
        if (strValue == null || strValue.isEmpty()) {
            return false;
        }
        if (kt == KOptionType.FILE) {
            kopt.setValue(new File(strValue));
        } else if (kt == KOptionType.DIR) {
            File dir = new File(strValue);
            if (!dir.exists()) {
                throw new IllegalArgumentException("Invalid dir:" + strValue);
            }
            kopt.setValue(dir);
        } else if (kt == KOptionType.INT) {
            try {
                Integer num = Integer.valueOf(strValue);
                kopt.setValue(num);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid integer:" + strValue);
            }
        } else if (kt == KOptionType.STR) {
            kopt.setValue(strValue);
        } else if (kt == KOptionType.DATE) {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy:HH:mm:ss");
            Date date = null;
            try {
                date = df.parse(strValue);
                kopt.setValue(date);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Fail to parse the date: " + strValue);
            }
        } else if (kt == KOptionType.BOOL) {
            kopt.setValue(Boolean.valueOf(strValue));
        } else {
            throw new IllegalArgumentException("Not recognised option:" + strValue);
        }
        return true;
    }

    public void add(KOption option) {
        if (option != null) {
            this.options.put(option, option);
        }
    }

    public void add(KOption option, Object optionValue) {
        if (option != null) {
            option.getOptionInfo().setValue(optionValue);
            this.add(option);
        }
    }

    public boolean contains(KOption option) {
        return this.options.containsKey(option);
    }

    public List<KOption> getOptions() {
        return new ArrayList<KOption>(this.options.keySet());
    }

    public KOption getOption(KOption option) {
        if (!this.options.containsKey(option)) {
            return null;
        }
        return this.options.get(option);
    }

    public Object getOptionValue(KOption option) {
        if (!this.contains(option)) {
            return null;
        }
        return this.options.get(option).getOptionInfo().getValue();
    }

    public String getStringOption(KOption option) {
        Object value = this.getOptionValue(option);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public boolean getBooleanOption(KOption option, Boolean defaultValue) {
        Object value = this.getOptionValue(option);
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.equalsIgnoreCase("true") || strVal.equalsIgnoreCase("yes") || strVal.equals("1")) {
                return true;
            }
            if (strVal.equalsIgnoreCase("false") || strVal.equalsIgnoreCase("no") || strVal.equals("0")) {
                return false;
            }
        } else if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public int getIntegerOption(KOption option) {
        Object value = this.getOptionValue(option);
        if (value instanceof String) {
            String strVal = (String)value;
            return Integer.parseInt(strVal);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }

    public File getFileOption(KOption option) {
        Object value = this.getOptionValue(option);
        if (value instanceof File) {
            return (File)value;
        }
        return null;
    }

    public File getDirOption(KOption option) {
        Object value = this.getOptionValue(option);
        if (value instanceof File) {
            return (File)value;
        }
        return null;
    }

    public Date getDateOption(KOption option) {
        Object value = this.getOptionValue(option);
        if (value instanceof Date) {
            return (Date)value;
        }
        return null;
    }
}

