/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks.Lease;

public class InterProcessSemaphoreMutex
implements InterProcessLock {
    private final InterProcessSemaphoreV2 semaphore;
    private volatile Lease lease;

    public InterProcessSemaphoreMutex(CuratorFramework client, String path) {
        this.semaphore = new InterProcessSemaphoreV2(client, path, 1);
    }

    @Override
    public void acquire() throws Exception {
        this.lease = this.semaphore.acquire();
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        Lease acquiredLease = this.semaphore.acquire(time, unit);
        if (acquiredLease == null) {
            return false;
        }
        this.lease = acquiredLease;
        return true;
    }

    @Override
    public void release() throws Exception {
        Preconditions.checkState(this.lease != null, "Not acquired");
        try {
            this.lease.close();
        }
        finally {
            this.lease = null;
        }
    }

    @Override
    public boolean isAcquiredInThisProcess() {
        return this.lease != null;
    }
}

