/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework.recipes.leader;

import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.leader.CancelLeadershipException;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.leader.Participant;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.hadoop.shaded.org.apache.curator.framework.state.ConnectionState;
import org.apache.hadoop.shaded.org.apache.curator.utils.CloseableExecutorService;
import org.apache.hadoop.shaded.org.apache.curator.utils.PathUtils;
import org.apache.hadoop.shaded.org.apache.curator.utils.ThreadUtils;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderSelector
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final LeaderSelectorListener listener;
    private final CloseableExecutorService executorService;
    private final InterProcessMutex mutex;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicBoolean autoRequeue = new AtomicBoolean(false);
    private final AtomicReference<Future<?>> ourTask = new AtomicReference<Object>(null);
    private volatile boolean hasLeadership;
    private volatile String id = "";
    @VisibleForTesting
    volatile CountDownLatch debugLeadershipLatch = null;
    volatile CountDownLatch debugLeadershipWaitLatch = null;
    private boolean isQueued = false;
    private static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory("LeaderSelector");

    public LeaderSelector(CuratorFramework client, String leaderPath, LeaderSelectorListener listener) {
        this(client, leaderPath, new CloseableExecutorService(Executors.newSingleThreadExecutor(defaultThreadFactory), true), listener);
    }

    @Deprecated
    public LeaderSelector(CuratorFramework client, String leaderPath, ThreadFactory threadFactory, Executor executor, LeaderSelectorListener listener) {
        this(client, leaderPath, new CloseableExecutorService(LeaderSelector.wrapExecutor(executor), true), listener);
    }

    public LeaderSelector(CuratorFramework client, String leaderPath, ExecutorService executorService, LeaderSelectorListener listener) {
        this(client, leaderPath, new CloseableExecutorService(executorService), listener);
    }

    public LeaderSelector(CuratorFramework client, String leaderPath, CloseableExecutorService executorService, LeaderSelectorListener listener) {
        Preconditions.checkNotNull(client, "client cannot be null");
        PathUtils.validatePath(leaderPath);
        Preconditions.checkNotNull(listener, "listener cannot be null");
        this.client = client;
        this.listener = new WrappedListener(this, listener);
        this.hasLeadership = false;
        this.executorService = executorService;
        this.mutex = new InterProcessMutex(client, leaderPath){

            @Override
            protected byte[] getLockNodeBytes() {
                return LeaderSelector.this.id.length() > 0 ? LeaderSelector.getIdBytes(LeaderSelector.this.id) : null;
            }
        };
    }

    static byte[] getIdBytes(String id) {
        try {
            return id.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public void autoRequeue() {
        this.autoRequeue.set(true);
    }

    public void setId(String id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void start() {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        Preconditions.checkState(!this.executorService.isShutdown(), "Already started");
        Preconditions.checkState(!this.hasLeadership, "Already has leadership");
        this.client.getConnectionStateListenable().addListener(this.listener);
        this.requeue();
    }

    public boolean requeue() {
        Preconditions.checkState(this.state.get() == State.STARTED, "close() has already been called");
        return this.internalRequeue();
    }

    public synchronized boolean internalRequeue() {
        if (!this.isQueued && this.state.get() == State.STARTED) {
            this.isQueued = true;
            Future<Void> task = this.executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        LeaderSelector.this.doWorkLoop();
                    }
                    finally {
                        LeaderSelector.this.clearIsQueued();
                        if (LeaderSelector.this.autoRequeue.get()) {
                            LeaderSelector.this.internalRequeue();
                        }
                    }
                    return null;
                }
            });
            this.ourTask.set(task);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        Preconditions.checkState(this.state.compareAndSet(State.STARTED, State.CLOSED), "Already closed or has not been started");
        this.client.getConnectionStateListenable().removeListener(this.listener);
        this.executorService.close();
        this.ourTask.set(null);
    }

    public Collection<Participant> getParticipants() throws Exception {
        Collection<String> participantNodes = this.mutex.getParticipantNodes();
        return LeaderSelector.getParticipants(this.client, participantNodes);
    }

    static Collection<Participant> getParticipants(CuratorFramework client, Collection<String> participantNodes) throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean isLeader = true;
        for (String path : participantNodes) {
            try {
                Participant participant = LeaderSelector.participantForPath(client, path, isLeader);
                builder.add(participant);
            }
            catch (KeeperException.NoNodeException ignore) {
                // empty catch block
            }
            isLeader = false;
        }
        return builder.build();
    }

    public Participant getLeader() throws Exception {
        Collection<String> participantNodes = this.mutex.getParticipantNodes();
        return LeaderSelector.getLeader(this.client, participantNodes);
    }

    static Participant getLeader(CuratorFramework client, Collection<String> participantNodes) throws Exception {
        if (participantNodes.size() > 0) {
            return LeaderSelector.participantForPath(client, participantNodes.iterator().next(), true);
        }
        return new Participant();
    }

    public boolean hasLeadership() {
        return this.hasLeadership;
    }

    public synchronized void interruptLeadership() {
        Future<?> task = this.ourTask.get();
        if (task != null) {
            task.cancel(true);
        }
    }

    private static Participant participantForPath(CuratorFramework client, String path, boolean markAsLeader) throws Exception {
        byte[] bytes = (byte[])client.getData().forPath(path);
        String thisId = new String(bytes, "UTF-8");
        return new Participant(thisId, markAsLeader);
    }

    @VisibleForTesting
    void doWork() throws Exception {
        this.hasLeadership = false;
        try {
            this.mutex.acquire();
            this.hasLeadership = true;
            try {
                if (this.debugLeadershipLatch != null) {
                    this.debugLeadershipLatch.countDown();
                }
                if (this.debugLeadershipWaitLatch != null) {
                    this.debugLeadershipWaitLatch.await();
                }
                this.listener.takeLeadership(this.client);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            catch (Throwable e) {
                this.log.error("The leader threw an exception", e);
            }
            finally {
                this.clearIsQueued();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.hasLeadership = false;
            try {
                this.mutex.release();
            }
            catch (Exception ignore) {}
        }
    }

    private void doWorkLoop() throws Exception {
        Throwable exception = null;
        try {
            this.doWork();
        }
        catch (KeeperException.ConnectionLossException e) {
            exception = e;
        }
        catch (KeeperException.SessionExpiredException e) {
            exception = e;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        if (exception != null && !this.autoRequeue.get()) {
            throw exception;
        }
    }

    private synchronized void clearIsQueued() {
        this.isQueued = false;
    }

    private static ExecutorService wrapExecutor(final Executor executor) {
        return new AbstractExecutorService(){
            private volatile boolean isShutdown = false;
            private volatile boolean isTerminated = false;

            @Override
            public void shutdown() {
                this.isShutdown = true;
            }

            @Override
            public List<Runnable> shutdownNow() {
                return Lists.newArrayList();
            }

            @Override
            public boolean isShutdown() {
                return this.isShutdown;
            }

            @Override
            public boolean isTerminated() {
                return this.isTerminated;
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void execute(Runnable command) {
                try {
                    executor.execute(command);
                }
                finally {
                    this.isShutdown = true;
                    this.isTerminated = true;
                }
            }
        };
    }

    private static class WrappedListener
    implements LeaderSelectorListener {
        private final LeaderSelector leaderSelector;
        private final LeaderSelectorListener listener;

        public WrappedListener(LeaderSelector leaderSelector, LeaderSelectorListener listener) {
            this.leaderSelector = leaderSelector;
            this.listener = listener;
        }

        @Override
        public void takeLeadership(CuratorFramework client) throws Exception {
            this.listener.takeLeadership(client);
        }

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            try {
                this.listener.stateChanged(client, newState);
            }
            catch (CancelLeadershipException dummy) {
                this.leaderSelector.interruptLeadership();
            }
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

