/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.avro.reflect;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.com.thoughtworks.paranamer.CachingParanamer;
import org.apache.hadoop.shaded.com.thoughtworks.paranamer.Paranamer;
import org.apache.hadoop.shaded.org.apache.avro.AvroRemoteException;
import org.apache.hadoop.shaded.org.apache.avro.AvroRuntimeException;
import org.apache.hadoop.shaded.org.apache.avro.AvroTypeException;
import org.apache.hadoop.shaded.org.apache.avro.Protocol;
import org.apache.hadoop.shaded.org.apache.avro.Schema;
import org.apache.hadoop.shaded.org.apache.avro.generic.GenericContainer;
import org.apache.hadoop.shaded.org.apache.avro.generic.GenericFixed;
import org.apache.hadoop.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.shaded.org.apache.avro.io.BinaryData;
import org.apache.hadoop.shaded.org.apache.avro.io.DatumReader;
import org.apache.hadoop.shaded.org.apache.avro.reflect.Nullable;
import org.apache.hadoop.shaded.org.apache.avro.reflect.ReflectDatumReader;
import org.apache.hadoop.shaded.org.apache.avro.reflect.Stringable;
import org.apache.hadoop.shaded.org.apache.avro.reflect.Union;
import org.apache.hadoop.shaded.org.apache.avro.specific.FixedSize;
import org.apache.hadoop.shaded.org.apache.avro.specific.SpecificData;
import org.apache.hadoop.shaded.org.codehaus.jackson.node.NullNode;

public class ReflectData
extends SpecificData {
    private static final ReflectData INSTANCE = new ReflectData();
    private Set<Class> stringableClasses = new HashSet<Class>();
    private static final Map<Class, Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap<Class, Map<String, Field>>();
    static final String CLASS_PROP = "java-class";
    static final String KEY_CLASS_PROP = "java-key-class";
    static final String ELEMENT_PROP = "java-element-class";
    private static final Class BYTES_CLASS = new byte[0].getClass();
    private static final Schema THROWABLE_MESSAGE = ReflectData.makeNullable(Schema.create(Schema.Type.STRING));
    private final Paranamer paranamer;

    public ReflectData() {
        this.stringableClasses.add(BigDecimal.class);
        this.stringableClasses.add(BigInteger.class);
        this.stringableClasses.add(URI.class);
        this.stringableClasses.add(URL.class);
        this.stringableClasses.add(File.class);
        this.paranamer = new CachingParanamer();
    }

    public ReflectData(ClassLoader classLoader) {
        super(classLoader);
        this.stringableClasses.add(BigDecimal.class);
        this.stringableClasses.add(BigInteger.class);
        this.stringableClasses.add(URI.class);
        this.stringableClasses.add(URL.class);
        this.stringableClasses.add(File.class);
        this.paranamer = new CachingParanamer();
    }

    public static ReflectData get() {
        return INSTANCE;
    }

    public ReflectData addStringable(Class c) {
        this.stringableClasses.add(c);
        return this;
    }

    @Override
    public DatumReader createDatumReader(Schema schema) {
        return new ReflectDatumReader(schema, schema, this);
    }

    @Override
    public void setField(Object record, String name, int position, Object o) {
        if (record instanceof IndexedRecord) {
            super.setField(record, name, position, o);
            return;
        }
        try {
            ReflectData.getField(record.getClass(), name).set(record, o);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public Object getField(Object record, String name, int position) {
        if (record instanceof IndexedRecord) {
            return super.getField(record, name, position);
        }
        try {
            return ReflectData.getField(record.getClass(), name).get(record);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    protected boolean isRecord(Object datum) {
        if (datum == null) {
            return false;
        }
        if (super.isRecord(datum)) {
            return true;
        }
        if (datum instanceof Collection) {
            return false;
        }
        if (datum instanceof Map) {
            return false;
        }
        return this.getSchema(datum.getClass()).getType() == Schema.Type.RECORD;
    }

    @Override
    protected boolean isArray(Object datum) {
        if (datum == null) {
            return false;
        }
        return datum instanceof Collection || datum.getClass().isArray();
    }

    @Override
    protected boolean isBytes(Object datum) {
        if (datum == null) {
            return false;
        }
        if (super.isBytes(datum)) {
            return true;
        }
        Class<?> c = datum.getClass();
        return c.isArray() && c.getComponentType() == Byte.TYPE;
    }

    @Override
    protected Schema getRecordSchema(Object record) {
        if (record instanceof GenericContainer) {
            return super.getRecordSchema(record);
        }
        return this.getSchema(record.getClass());
    }

    @Override
    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case ARRAY: {
                if (!datum.getClass().isArray()) {
                    return super.validate(schema, datum);
                }
                int length = Array.getLength(datum);
                for (int i = 0; i < length; ++i) {
                    if (this.validate(schema.getElementType(), Array.get(datum, i))) continue;
                    return false;
                }
                return true;
            }
        }
        return super.validate(schema, datum);
    }

    private static Field getField(Class c, String name) {
        Field f;
        Map<String, Field> fields = FIELD_CACHE.get(c);
        if (fields == null) {
            fields = new ConcurrentHashMap<String, Field>();
            FIELD_CACHE.put(c, fields);
        }
        if ((f = fields.get(name)) == null) {
            f = ReflectData.findField(c, name);
            fields.put(name, f);
        }
        return f;
    }

    private static Field findField(Class original, String name) {
        Class c = original;
        while (true) {
            try {
                Field f = c.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((c = c.getSuperclass()) != null) continue;
                throw new AvroRuntimeException("No field named " + name + " in: " + original);
            }
            break;
        }
    }

    static Class getClassProp(Schema schema, String prop) {
        String name = schema.getProp(prop);
        if (name == null) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public Class getClass(Schema schema) {
        switch (schema.getType()) {
            case ARRAY: {
                Class collectionClass = ReflectData.getClassProp(schema, CLASS_PROP);
                if (collectionClass != null) {
                    return collectionClass;
                }
                return Array.newInstance(this.getClass(schema.getElementType()), 0).getClass();
            }
            case STRING: {
                Class stringClass = ReflectData.getClassProp(schema, CLASS_PROP);
                if (stringClass != null) {
                    return stringClass;
                }
                return String.class;
            }
            case BYTES: {
                return BYTES_CLASS;
            }
            case INT: {
                String intClass = schema.getProp(CLASS_PROP);
                if (Byte.class.getName().equals(intClass)) {
                    return Byte.TYPE;
                }
                if (!Short.class.getName().equals(intClass)) break;
                return Short.TYPE;
            }
        }
        return super.getClass(schema);
    }

    @Override
    protected Schema createSchema(Type type, Map<String, Schema> names) {
        if (type instanceof GenericArrayType) {
            Type component = ((GenericArrayType)type).getGenericComponentType();
            if (component == Byte.TYPE) {
                return Schema.create(Schema.Type.BYTES);
            }
            Schema result = Schema.createArray(this.createSchema(component, names));
            this.setElement(result, component);
            return result;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class raw = (Class)ptype.getRawType();
            Type[] params = ptype.getActualTypeArguments();
            if (Map.class.isAssignableFrom(raw)) {
                Schema schema = Schema.createMap(this.createSchema(params[1], names));
                Class key = (Class)params[0];
                if (this.isStringable(key)) {
                    schema.addProp(KEY_CLASS_PROP, key.getName());
                } else if (key != String.class) {
                    throw new AvroTypeException("Map key class not String: " + key);
                }
                return schema;
            }
            if (Collection.class.isAssignableFrom(raw)) {
                if (params.length != 1) {
                    throw new AvroTypeException("No array type specified.");
                }
                Schema schema = Schema.createArray(this.createSchema(params[0], names));
                schema.addProp(CLASS_PROP, raw.getName());
                return schema;
            }
        } else {
            if (type == Byte.class || type == Byte.TYPE) {
                Schema result = Schema.create(Schema.Type.INT);
                result.addProp(CLASS_PROP, Byte.class.getName());
                return result;
            }
            if (type == Short.class || type == Short.TYPE) {
                Schema result = Schema.create(Schema.Type.INT);
                result.addProp(CLASS_PROP, Short.class.getName());
                return result;
            }
            if (type instanceof Class) {
                Class c = (Class)type;
                if (c.isPrimitive() || c == Void.class || c == Boolean.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class || c == Byte.class || c == Short.class || c == Character.class) {
                    return super.createSchema(type, names);
                }
                if (c.isArray()) {
                    Class<?> component = c.getComponentType();
                    if (component == Byte.TYPE) {
                        Schema result = Schema.create(Schema.Type.BYTES);
                        result.addProp(CLASS_PROP, c.getName());
                        return result;
                    }
                    Schema result = Schema.createArray(this.createSchema(component, names));
                    result.addProp(CLASS_PROP, c.getName());
                    this.setElement(result, component);
                    return result;
                }
                if (CharSequence.class.isAssignableFrom(c)) {
                    return Schema.create(Schema.Type.STRING);
                }
                if (ByteBuffer.class.isAssignableFrom(c)) {
                    return Schema.create(Schema.Type.BYTES);
                }
                if (Collection.class.isAssignableFrom(c)) {
                    throw new AvroRuntimeException("Can't find element type of Collection");
                }
                String fullName = c.getName();
                Schema schema = names.get(fullName);
                if (schema == null) {
                    Union union;
                    String space;
                    String name = c.getSimpleName();
                    String string = space = c.getPackage() == null ? "" : c.getPackage().getName();
                    if (c.getEnclosingClass() != null) {
                        space = c.getEnclosingClass().getName() + "$";
                    }
                    if ((union = c.getAnnotation(Union.class)) != null) {
                        return this.getAnnotatedUnion(union, names);
                    }
                    if (this.isStringable(c)) {
                        Schema result = Schema.create(Schema.Type.STRING);
                        result.addProp(CLASS_PROP, c.getName());
                        return result;
                    }
                    if (c.isEnum()) {
                        ArrayList<String> symbols = new ArrayList<String>();
                        Enum[] constants = (Enum[])c.getEnumConstants();
                        for (int i = 0; i < constants.length; ++i) {
                            symbols.add(constants[i].name());
                        }
                        schema = Schema.createEnum(name, null, space, symbols);
                    } else if (GenericFixed.class.isAssignableFrom(c)) {
                        int size = c.getAnnotation(FixedSize.class).value();
                        schema = Schema.createFixed(name, null, space, size);
                    } else {
                        if (IndexedRecord.class.isAssignableFrom(c)) {
                            return super.createSchema(type, names);
                        }
                        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                        boolean error = Throwable.class.isAssignableFrom(c);
                        schema = Schema.createRecord(name, null, space, error);
                        names.put(c.getName(), schema);
                        for (Field field : this.getFields(c)) {
                            Schema defaultType;
                            if ((field.getModifiers() & 0x88) != 0) continue;
                            Schema fieldSchema = this.createFieldSchema(field, names);
                            NullNode defaultValue = null;
                            if (fieldSchema.getType() == Schema.Type.UNION && (defaultType = fieldSchema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                                defaultValue = NullNode.getInstance();
                            }
                            fields.add(new Schema.Field(field.getName(), fieldSchema, null, defaultValue));
                        }
                        if (error) {
                            fields.add(new Schema.Field("detailMessage", THROWABLE_MESSAGE, null, null));
                        }
                        schema.setFields(fields);
                    }
                    names.put(fullName, schema);
                }
                return schema;
            }
        }
        return super.createSchema(type, names);
    }

    private boolean isStringable(Class<?> c) {
        return c.isAnnotationPresent(Stringable.class) || this.stringableClasses.contains(c);
    }

    private void setElement(Schema schema, Type element) {
        if (!(element instanceof Class)) {
            return;
        }
        Class c = (Class)element;
        Union union = c.getAnnotation(Union.class);
        if (union != null) {
            schema.addProp(ELEMENT_PROP, c.getName());
        }
    }

    private Schema getAnnotatedUnion(Union union, Map<String, Schema> names) {
        ArrayList<Schema> branches = new ArrayList<Schema>();
        for (Class branch : union.value()) {
            branches.add(this.createSchema(branch, names));
        }
        return Schema.createUnion(branches);
    }

    public static Schema makeNullable(Schema schema) {
        return Schema.createUnion(Arrays.asList(Schema.create(Schema.Type.NULL), schema));
    }

    private Collection<Field> getFields(Class recordClass) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class c = recordClass;
        while (c.getPackage() == null || !c.getPackage().getName().startsWith("java.")) {
            for (Field field : c.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0 || fields.put(field.getName(), field) == null) continue;
                throw new AvroTypeException(c + " contains two fields named: " + field);
            }
            if ((c = c.getSuperclass()) != null) continue;
        }
        return fields.values();
    }

    protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
        Schema schema = this.createSchema(field.getGenericType(), names);
        if (field.isAnnotationPresent(Nullable.class)) {
            schema = ReflectData.makeNullable(schema);
        }
        return schema;
    }

    @Override
    public Protocol getProtocol(Class iface) {
        Protocol protocol = new Protocol(iface.getSimpleName(), iface.getPackage() == null ? "" : iface.getPackage().getName());
        LinkedHashMap<String, Schema> names = new LinkedHashMap<String, Schema>();
        Map<String, Protocol.Message> messages = protocol.getMessages();
        for (Method method : iface.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            String name = method.getName();
            if (messages.containsKey(name)) {
                throw new AvroTypeException("Two methods with same name: " + name);
            }
            messages.put(name, this.getMessage(method, protocol, names));
        }
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.addAll(names.values());
        Collections.reverse(types);
        protocol.setTypes(types);
        return protocol;
    }

    private Protocol.Message getMessage(Method method, Protocol protocol, Map<String, Schema> names) {
        Schema response;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        String[] paramNames = this.paranamer.lookupParameterNames(method);
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            Schema paramSchema = this.getSchema(paramTypes[i], names);
            for (int j = 0; j < annotations[i].length; ++j) {
                if (annotations[i][j] instanceof Union) {
                    paramSchema = this.getAnnotatedUnion((Union)annotations[i][j], names);
                    continue;
                }
                if (!(annotations[i][j] instanceof Nullable)) continue;
                paramSchema = ReflectData.makeNullable(paramSchema);
            }
            String paramName = paramNames.length == paramTypes.length ? paramNames[i] : paramSchema.getName() + i;
            fields.add(new Schema.Field(paramName, paramSchema, null, null));
        }
        Schema request = Schema.createRecord(fields);
        Union union = method.getAnnotation(Union.class);
        Schema schema = response = union == null ? this.getSchema(method.getGenericReturnType(), names) : this.getAnnotatedUnion(union, names);
        if (method.isAnnotationPresent(Nullable.class)) {
            response = ReflectData.makeNullable(response);
        }
        ArrayList<Schema> errs = new ArrayList<Schema>();
        errs.add(Protocol.SYSTEM_ERROR);
        for (Type err : method.getGenericExceptionTypes()) {
            if (err == AvroRemoteException.class) continue;
            errs.add(this.getSchema(err, names));
        }
        Schema errors = Schema.createUnion(errs);
        return protocol.createMessage(method.getName(), null, request, response, errors);
    }

    private Schema getSchema(Type type, Map<String, Schema> names) {
        try {
            return this.createSchema(type, names);
        }
        catch (AvroTypeException e) {
            throw new AvroTypeException("Error getting schema for " + type + ": " + e.getMessage(), e);
        }
    }

    @Override
    protected String getSchemaName(Object datum) {
        Class<?> c;
        if (datum != null && this.isStringable(c = datum.getClass())) {
            return Schema.Type.STRING.getName();
        }
        return super.getSchemaName(datum);
    }

    @Override
    protected int compare(Object o1, Object o2, Schema s, boolean equals) {
        switch (s.getType()) {
            case ARRAY: {
                if (!o1.getClass().isArray()) break;
                Schema elementType = s.getElementType();
                int l1 = Array.getLength(o1);
                int l2 = Array.getLength(o2);
                int l = Math.min(l1, l2);
                for (int i = 0; i < l; ++i) {
                    int compare = this.compare(Array.get(o1, i), Array.get(o2, i), elementType, equals);
                    if (compare == 0) continue;
                    return compare;
                }
                return l1 - l2;
            }
            case BYTES: {
                if (!o1.getClass().isArray()) break;
                byte[] b1 = (byte[])o1;
                byte[] b2 = (byte[])o2;
                return BinaryData.compareBytes(b1, 0, b1.length, b2, 0, b2.length);
            }
        }
        return super.compare(o1, o2, s, equals);
    }

    public static class AllowNull
    extends ReflectData {
        private static final AllowNull INSTANCE = new AllowNull();

        public static AllowNull get() {
            return INSTANCE;
        }

        @Override
        protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
            Schema schema = super.createFieldSchema(field, names);
            return AllowNull.makeNullable(schema);
        }
    }
}

