/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.net.minidev.json.parser;

import java.io.IOException;
import org.apache.hadoop.shaded.net.minidev.json.JSONStyle;
import org.apache.hadoop.shaded.net.minidev.json.JSONValue;
import org.apache.hadoop.shaded.net.minidev.json.parser.ContentHandler;
import org.apache.hadoop.shaded.net.minidev.json.parser.ParseException;

public class ContentHandlerCompressor
implements ContentHandler {
    Appendable out;
    JSONStyle compression;
    int[] stack = new int[10];
    int pos;

    private void push(int type) {
        this.pos += 2;
        if (this.pos >= this.stack.length) {
            int[] tmp = new int[this.stack.length * 2];
            System.arraycopy(this.stack, 0, tmp, 0, this.stack.length);
            this.stack = tmp;
        }
        this.stack[this.pos] = type;
        this.stack[this.pos + 1] = 0;
    }

    private boolean isInObject() {
        return this.stack[this.pos] == 0;
    }

    private boolean isInArray() {
        return this.stack[this.pos] == 1;
    }

    public ContentHandlerCompressor(Appendable out, JSONStyle compression) {
        this.out = out;
        this.compression = compression;
    }

    public void startJSON() throws ParseException, IOException {
    }

    public void endJSON() throws ParseException, IOException {
    }

    public boolean startObject() throws ParseException, IOException {
        if (this.isInArray()) {
            int n = this.pos + 1;
            int n2 = this.stack[n];
            this.stack[n] = n2 + 1;
            if (n2 > 0) {
                this.out.append(',');
            }
        }
        this.out.append('{');
        this.push(0);
        return false;
    }

    public boolean endObject() throws ParseException, IOException {
        this.out.append('}');
        this.pos -= 2;
        return false;
    }

    public boolean startObjectEntry(String key) throws ParseException, IOException {
        int n = this.pos + 1;
        int n2 = this.stack[n];
        this.stack[n] = n2 + 1;
        if (n2 > 0) {
            this.out.append(',');
        }
        if (key == null) {
            this.out.append("null");
        } else if (!this.compression.mustProtectKey(key)) {
            this.out.append(key);
        } else {
            this.out.append('\"');
            JSONValue.escape(key, this.out, this.compression);
            this.out.append('\"');
        }
        this.out.append(':');
        return false;
    }

    public boolean endObjectEntry() throws ParseException, IOException {
        return false;
    }

    public boolean startArray() throws ParseException, IOException {
        if (this.isInArray()) {
            int n = this.pos + 1;
            int n2 = this.stack[n];
            this.stack[n] = n2 + 1;
            if (n2 > 0) {
                this.out.append(',');
            }
        }
        this.out.append('[');
        this.push(1);
        return false;
    }

    public boolean endArray() throws ParseException, IOException {
        this.out.append(']');
        this.pos -= 2;
        return false;
    }

    public boolean primitive(Object value) throws ParseException, IOException {
        if (!this.isInObject()) {
            int n = this.pos + 1;
            int n2 = this.stack[n];
            this.stack[n] = n2 + 1;
            if (n2 > 0) {
                this.out.append(',');
            }
        }
        if (value instanceof String) {
            if (!this.compression.mustProtectValue((String)value)) {
                this.out.append((String)value);
            } else {
                this.out.append('\"');
                JSONValue.escape((String)value, this.out, this.compression);
                this.out.append('\"');
            }
        } else {
            JSONValue.writeJSONString(value, this.out, this.compression);
        }
        return false;
    }
}

