/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWECryptoParts;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEEncrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AES;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESCBC;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESGCM;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AuthenticatedCipherText;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.DeflateHelper;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.RSA1_5;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.RSACryptoProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.RSA_OAEP;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.RSA_OAEP_256;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.StringUtils;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSAEncrypter
extends RSACryptoProvider
implements JWEEncrypter {
    private final RSAPublicKey publicKey;

    public RSAEncrypter(RSAPublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] bytes) throws JOSEException {
        AuthenticatedCipherText authCipherText;
        byte[] iv;
        Base64URL encryptedKey;
        JWEAlgorithm alg = header.getAlgorithm();
        EncryptionMethod enc = header.getEncryptionMethod();
        SecureRandom randomGen = this.getSecureRandom();
        SecretKey cek = AES.generateKey(enc.cekBitLength(), randomGen);
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            encryptedKey = Base64URL.encode(RSA1_5.encryptCEK(this.publicKey, cek, this.keyEncryptionProvider));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            encryptedKey = Base64URL.encode(RSA_OAEP.encryptCEK(this.publicKey, cek, this.keyEncryptionProvider));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_256)) {
            encryptedKey = Base64URL.encode(RSA_OAEP_256.encryptCEK(this.publicKey, cek, this.keyEncryptionProvider));
        } else {
            throw new JOSEException("Unsupported JWE algorithm, must be RSA1_5, RSA-OAEP, or RSA-OAEP-256");
        }
        byte[] plainText = DeflateHelper.applyCompression(header, bytes);
        byte[] aad = StringUtils.toByteArray(header.toBase64URL().toString());
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A192CBC_HS384) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptAuthenticated(cek, iv, plainText, aad, this.contentEncryptionProvider, this.macProvider);
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A192GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            iv = AESGCM.generateIV(randomGen);
            authCipherText = AESGCM.encrypt(cek, iv, plainText, aad, this.contentEncryptionProvider);
        } else if (enc.equals(EncryptionMethod.A128CBC_HS256_DEPRECATED) || enc.equals(EncryptionMethod.A256CBC_HS512_DEPRECATED)) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptWithConcatKDF(header, cek, encryptedKey, iv, plainText, this.contentEncryptionProvider, this.macProvider);
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A192CBC_HS384, A256CBC_HS512, A128GCM, A192GCM or A256GCM");
        }
        return new JWECryptoParts(encryptedKey, Base64URL.encode(iv), Base64URL.encode(authCipherText.getCipherText()), Base64URL.encode(authCipherText.getAuthenticationTag()));
    }
}

