/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSSigner;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.HMAC;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.MACProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MACSigner
extends MACProvider
implements JWSSigner {
    public static int getMinRequiredSecretSize(JWSAlgorithm hmacAlg) throws JOSEException {
        if (JWSAlgorithm.HS256.equals(hmacAlg)) {
            return 256;
        }
        if (JWSAlgorithm.HS384.equals(hmacAlg)) {
            return 384;
        }
        if (JWSAlgorithm.HS512.equals(hmacAlg)) {
            return 512;
        }
        throw new JOSEException("Unsupported HMAC algorithm, must be HS256, HS384 or HS512");
    }

    public MACSigner(byte[] sharedSecret) {
        super(sharedSecret);
    }

    public MACSigner(String sharedSecretString) {
        super(sharedSecretString);
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        int minRequiredKeyLength = MACSigner.getMinRequiredSecretSize(header.getAlgorithm());
        if (this.getSharedSecret().length < minRequiredKeyLength / 8) {
            throw new JOSEException("The shared secret size must be at least " + minRequiredKeyLength + " bits for " + header.getAlgorithm());
        }
        String jcaAlg = MACSigner.getJCAAlgorithmName(header.getAlgorithm());
        byte[] hmac = HMAC.compute(jcaAlg, this.getSharedSecret(), signingInput, this.provider);
        return Base64URL.encode(hmac);
    }
}

