/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWECryptoParts;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEEncrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESCBC;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESGCM;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AuthenticatedCipherText;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.DeflateHelper;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.DirectCryptoProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.StringUtils;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws JOSEException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws JOSEException {
        super(keyBytes);
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        AuthenticatedCipherText authCipherText;
        byte[] iv;
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException("Unsupported JWE algorithm, must be \"dir\"");
        }
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.cekBitLength() != this.getKey().getEncoded().length * 8) {
            throw new JOSEException("The Content Encryption Key (CEK) length must be " + enc.cekBitLength() + " bits for " + enc + " encryption");
        }
        Base64URL encryptedKey = null;
        byte[] plainText = DeflateHelper.applyCompression(readOnlyJWEHeader, bytes);
        byte[] aad = StringUtils.toByteArray(readOnlyJWEHeader.toBase64URL().toString());
        SecureRandom randomGen = this.getSecureRandom();
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A192CBC_HS384) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptAuthenticated(this.getKey(), iv, plainText, aad, this.contentEncryptionProvider, this.macProvider);
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A192GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            iv = AESGCM.generateIV(randomGen);
            authCipherText = AESGCM.encrypt(this.getKey(), iv, plainText, aad, this.contentEncryptionProvider);
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A192CBC_HS384, A256CBC_HS512, A128GCM, A192GCM or A128GCM");
        }
        return new JWECryptoParts(encryptedKey, Base64URL.encode(iv), Base64URL.encode(authCipherText.getCipherText()), Base64URL.encode(authCipherText.getAuthenticationTag()));
    }
}

