/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEDecrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESCBC;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESGCM;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.CriticalHeaderParameterChecker;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.DeflateHelper;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.DirectCryptoProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.StringUtils;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectDecrypter
extends DirectCryptoProvider
implements JWEDecrypter {
    private Set<JWEAlgorithm> acceptedAlgs = new HashSet<JWEAlgorithm>(this.supportedAlgorithms());
    private Set<EncryptionMethod> acceptedEncs = new HashSet<EncryptionMethod>(this.supportedEncryptionMethods());
    private final CriticalHeaderParameterChecker critParamChecker = new CriticalHeaderParameterChecker();

    public DirectDecrypter(SecretKey key) throws JOSEException {
        super(key);
    }

    public DirectDecrypter(byte[] keyBytes) throws JOSEException {
        super(keyBytes);
    }

    @Override
    public Set<JWEAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWEAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWE algorithms must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("Unsupported JWE algorithm(s)");
        }
        this.acceptedAlgs = acceptedAlgs;
    }

    @Override
    public Set<EncryptionMethod> getAcceptedEncryptionMethods() {
        return this.acceptedEncs;
    }

    @Override
    public void setAcceptedEncryptionMethods(Set<EncryptionMethod> acceptedEncs) {
        if (acceptedEncs == null) {
            throw new IllegalArgumentException("The accepted encryption methods must not be null");
        }
        if (!this.supportedEncryptionMethods().containsAll(acceptedEncs)) {
            throw new IllegalArgumentException("Unsupported encryption method(s)");
        }
        this.acceptedEncs = acceptedEncs;
    }

    @Override
    public Set<String> getIgnoredCriticalHeaderParameters() {
        return this.critParamChecker.getIgnoredCriticalHeaders();
    }

    @Override
    public void setIgnoredCriticalHeaderParameters(Set<String> headers) {
        this.critParamChecker.setIgnoredCriticalHeaders(headers);
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        byte[] plainText;
        if (encryptedKey != null) {
            throw new JOSEException("Unexpected encrypted key, must be omitted");
        }
        if (iv == null) {
            throw new JOSEException("The initialization vector (IV) must not be null");
        }
        if (authTag == null) {
            throw new JOSEException("The authentication tag must not be null");
        }
        JWEAlgorithm alg = header.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException("Unsupported algorithm, must be \"dir\"");
        }
        if (!this.critParamChecker.headerPasses(header)) {
            throw new JOSEException("Unsupported critical header parameter");
        }
        byte[] aad = StringUtils.toByteArray(header.toBase64URL().toString());
        EncryptionMethod enc = header.getEncryptionMethod();
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A192CBC_HS384) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            plainText = AESCBC.decryptAuthenticated(this.getKey(), iv.decode(), cipherText.decode(), aad, authTag.decode(), this.contentEncryptionProvider, this.macProvider);
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A192GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            plainText = AESGCM.decrypt(this.getKey(), iv.decode(), cipherText.decode(), aad, authTag.decode(), this.contentEncryptionProvider);
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A192CBC_HS384, A256CBC_HS512, A128GCM, A192GCM or A128GCM");
        }
        return DeflateHelper.applyDecompression(header, plainText);
    }
}

