/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithmProvider;

abstract class BaseJWEProvider
implements JWEAlgorithmProvider {
    private final Set<JWEAlgorithm> algs;
    private final Set<EncryptionMethod> encs;
    protected Provider keyEncryptionProvider = null;
    protected Provider contentEncryptionProvider = null;
    protected Provider macProvider = null;
    private SecureRandom randomGen = null;

    public BaseJWEProvider(Set<JWEAlgorithm> algs, Set<EncryptionMethod> encs) {
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWE algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
        if (encs == null) {
            throw new IllegalArgumentException("The supported encryption methods must not be null");
        }
        this.encs = encs;
    }

    @Override
    public Set<JWEAlgorithm> supportedAlgorithms() {
        return this.algs;
    }

    @Override
    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return this.encs;
    }

    @Override
    public void setProvider(Provider provider) {
        this.setKeyEncryptionProvider(provider);
        this.setContentEncryptionProvider(provider);
        this.setMACProvider(provider);
    }

    @Override
    public void setKeyEncryptionProvider(Provider provider) {
        this.keyEncryptionProvider = provider;
    }

    @Override
    public void setContentEncryptionProvider(Provider provider) {
        this.contentEncryptionProvider = provider;
    }

    @Override
    public void setMACProvider(Provider provider) {
        this.macProvider = provider;
    }

    @Override
    public void setSecureRandom(SecureRandom randomGen) {
        this.randomGen = randomGen;
    }

    protected SecureRandom getSecureRandom() {
        if (this.randomGen == null) {
            this.randomGen = new SecureRandom();
            return this.randomGen;
        }
        return this.randomGen;
    }
}

