/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;
import org.apache.hadoop.shaded.org.bouncycastle.crypto.CipherParameters;
import org.apache.hadoop.shaded.org.bouncycastle.crypto.engines.AESWrapEngine;
import org.apache.hadoop.shaded.org.bouncycastle.crypto.params.KeyParameter;

@ThreadSafe
class AESKW {
    public static byte[] encryptCEK(SecretKey cek, SecretKey kek) throws JOSEException {
        byte[] cekBytes = cek.getEncoded();
        AESWrapEngine encrypter = new AESWrapEngine();
        encrypter.init(true, (CipherParameters)new KeyParameter(kek.getEncoded()));
        try {
            return encrypter.wrap(cekBytes, 0, cekBytes.length);
        }
        catch (Exception e) {
            throw new JOSEException("Couldn't encrypt Content Encryption Key (CEK): " + e.getMessage(), e);
        }
    }

    public static SecretKey decryptCEK(SecretKey kek, byte[] encryptedCEK) throws JOSEException {
        AESWrapEngine decrypter = new AESWrapEngine();
        decrypter.init(false, (CipherParameters)new KeyParameter(kek.getEncoded()));
        try {
            byte[] cekBytes = decrypter.unwrap(encryptedCEK, 0, encryptedCEK.length);
            return new SecretKeySpec(cekBytes, "AES");
        }
        catch (Exception e) {
            throw new JOSEException("Couldn't decrypt Content Encryption Key (CEK): " + e.getMessage(), e);
        }
    }

    private AESKW() {
    }
}

