/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEDecrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESCBC;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESCryptoProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESGCM;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESGCMKW;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AESKW;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AuthenticatedCipherText;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.CriticalHeaderParameterChecker;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.DeflateHelper;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.StringUtils;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESDecrypter
extends AESCryptoProvider
implements JWEDecrypter {
    private Set<JWEAlgorithm> acceptedAlgs;
    private Set<EncryptionMethod> acceptedEncs = new HashSet<EncryptionMethod>(this.supportedEncryptionMethods());
    private final CriticalHeaderParameterChecker critParamChecker = new CriticalHeaderParameterChecker();
    private final SecretKey kek;

    public AESDecrypter(SecretKey kek) {
        if (kek == null) {
            throw new IllegalArgumentException("The Key Encrypting Key must not be null");
        }
        this.kek = kek;
        this.acceptedAlgs = this.compatibleAlgorithms();
        if (this.acceptedAlgs == null) {
            throw new IllegalArgumentException("The Key Encrypting Key must be 128, 192 or 256 bits long");
        }
    }

    public AESDecrypter(byte[] keyBytes) throws IllegalArgumentException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public Set<JWEAlgorithm> compatibleAlgorithms() {
        return (Set)COMPATIBLE_ALGORITHMS.get(this.kek.getEncoded().length);
    }

    public SecretKey getKey() {
        return this.kek;
    }

    @Override
    public Set<JWEAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWEAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWE algorithms must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("Unsupported JWE algorithm(s)");
        }
        if (!this.compatibleAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("JWE algorithm(s) not compatible with key size");
        }
        this.acceptedAlgs = acceptedAlgs;
    }

    @Override
    public Set<EncryptionMethod> getAcceptedEncryptionMethods() {
        return this.acceptedEncs;
    }

    @Override
    public void setAcceptedEncryptionMethods(Set<EncryptionMethod> acceptedEncs) {
        if (acceptedEncs == null) {
            throw new IllegalArgumentException("The accepted encryption methods must not be null");
        }
        if (!this.supportedEncryptionMethods().containsAll(acceptedEncs)) {
            throw new IllegalArgumentException("Unsupported encryption method(s)");
        }
        this.acceptedEncs = acceptedEncs;
    }

    @Override
    public Set<String> getIgnoredCriticalHeaderParameters() {
        return this.critParamChecker.getIgnoredCriticalHeaders();
    }

    @Override
    public void setIgnoredCriticalHeaderParameters(Set<String> headers) {
        this.critParamChecker.setIgnoredCriticalHeaders(headers);
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        byte[] plainText;
        SecretKey cek;
        if (encryptedKey == null) {
            throw new JOSEException("The encrypted key must not be null");
        }
        if (iv == null) {
            throw new JOSEException("The initialization vector (IV) must not be null");
        }
        if (authTag == null) {
            throw new JOSEException("The authentication tag must not be null");
        }
        if (!this.critParamChecker.headerPasses(header)) {
            throw new JOSEException("Unsupported critical header parameter");
        }
        JWEAlgorithm alg = header.getAlgorithm();
        int keyLength = header.getEncryptionMethod().cekBitLength();
        if (alg.equals(JWEAlgorithm.A128KW) || alg.equals(JWEAlgorithm.A192KW) || alg.equals(JWEAlgorithm.A256KW)) {
            cek = AESKW.decryptCEK(this.kek, encryptedKey.decode());
        } else if (alg.equals(JWEAlgorithm.A128GCMKW) || alg.equals(JWEAlgorithm.A192GCMKW) || alg.equals(JWEAlgorithm.A256GCMKW)) {
            byte[] keyIV = header.getIV().decode();
            byte[] keyTag = header.getAuthTag().decode();
            AuthenticatedCipherText authEncrCEK = new AuthenticatedCipherText(encryptedKey.decode(), keyTag);
            cek = AESGCMKW.decryptCEK(this.kek, keyIV, authEncrCEK, keyLength, this.keyEncryptionProvider);
        } else {
            throw new JOSEException("Unsupported JWE algorithm, must be A128KW, A192KW, A256KW, A128GCMKW, A192GCMKW orA256GCMKW");
        }
        byte[] aad = StringUtils.toByteArray(header.toBase64URL().toString());
        EncryptionMethod enc = header.getEncryptionMethod();
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A192CBC_HS384) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            plainText = AESCBC.decryptAuthenticated(cek, iv.decode(), cipherText.decode(), aad, authTag.decode(), this.contentEncryptionProvider, this.macProvider);
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A192GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            plainText = AESGCM.decrypt(cek, iv.decode(), cipherText.decode(), aad, authTag.decode(), this.contentEncryptionProvider);
        } else if (enc.equals(EncryptionMethod.A128CBC_HS256_DEPRECATED) || enc.equals(EncryptionMethod.A256CBC_HS512_DEPRECATED)) {
            plainText = AESCBC.decryptWithConcatKDF(header, cek, encryptedKey, iv, cipherText, authTag, this.contentEncryptionProvider, this.macProvider);
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A192CBC_HS384, A256CBC_HS512, A128GCM, A192GCM or A256GCM");
        }
        return DeflateHelper.applyDecompression(header, plainText);
    }
}

