/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose;

import java.nio.charset.Charset;
import java.text.ParseException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEObject;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSSigner;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSVerifier;
import org.apache.hadoop.shaded.com.nimbusds.jose.Payload;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWSObject
extends JOSEObject {
    private final JWSHeader header;
    private final String signingInputString;
    private Base64URL signature;
    private State state;

    public JWSObject(JWSHeader header, Payload payload) {
        if (header == null) {
            throw new IllegalArgumentException("The JWS header must not be null");
        }
        this.header = header;
        if (payload == null) {
            throw new IllegalArgumentException("The payload must not be null");
        }
        this.setPayload(payload);
        this.signingInputString = JWSObject.composeSigningInput(header.toBase64URL(), payload.toBase64URL());
        this.signature = null;
        this.state = State.UNSIGNED;
    }

    public JWSObject(Base64URL firstPart, Base64URL secondPart, Base64URL thirdPart) throws ParseException {
        if (firstPart == null) {
            throw new IllegalArgumentException("The first part must not be null");
        }
        try {
            this.header = JWSHeader.parse(firstPart);
        }
        catch (ParseException e) {
            throw new ParseException("Invalid JWS header: " + e.getMessage(), 0);
        }
        if (secondPart == null) {
            throw new IllegalArgumentException("The second part must not be null");
        }
        this.setPayload(new Payload(secondPart));
        this.signingInputString = JWSObject.composeSigningInput(firstPart, secondPart);
        if (thirdPart == null) {
            throw new IllegalArgumentException("The third part must not be null");
        }
        this.signature = thirdPart;
        this.state = State.SIGNED;
        this.setParsedParts(firstPart, secondPart, thirdPart);
    }

    @Override
    public JWSHeader getHeader() {
        return this.header;
    }

    private static String composeSigningInput(Base64URL firstPart, Base64URL secondPart) {
        StringBuilder sb = new StringBuilder(firstPart.toString());
        sb.append('.');
        sb.append(secondPart.toString());
        return sb.toString();
    }

    public byte[] getSigningInput() {
        return this.signingInputString.getBytes(Charset.forName("UTF-8"));
    }

    @Deprecated
    public byte[] getSignableContent() {
        return this.getSigningInput();
    }

    public Base64URL getSignature() {
        return this.signature;
    }

    public State getState() {
        return this.state;
    }

    private void ensureUnsignedState() {
        if (this.state != State.UNSIGNED) {
            throw new IllegalStateException("The JWS object must be in an unsigned state");
        }
    }

    private void ensureSignedOrVerifiedState() {
        if (this.state != State.SIGNED && this.state != State.VERIFIED) {
            throw new IllegalStateException("The JWS object must be in a signed or verified state");
        }
    }

    private void ensureJWSSignerSupport(JWSSigner signer) throws JOSEException {
        if (!signer.supportedAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The \"" + this.getHeader().getAlgorithm() + "\" algorithm is not supported by the JWS signer");
        }
    }

    private void ensureJWSVerifierAcceptance(JWSVerifier verifier) throws JOSEException {
        if (!verifier.getAcceptedAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The \"" + this.getHeader().getAlgorithm() + "\" algorithm is not accepted by the JWS verifier");
        }
    }

    public synchronized void sign(JWSSigner signer) throws JOSEException {
        this.ensureUnsignedState();
        this.ensureJWSSignerSupport(signer);
        try {
            this.signature = signer.sign(this.getHeader(), this.getSigningInput());
        }
        catch (JOSEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        this.state = State.SIGNED;
    }

    public synchronized boolean verify(JWSVerifier verifier) throws JOSEException {
        boolean verified;
        this.ensureSignedOrVerifiedState();
        this.ensureJWSVerifierAcceptance(verifier);
        try {
            verified = verifier.verify(this.getHeader(), this.getSigningInput(), this.getSignature());
        }
        catch (JOSEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        if (verified) {
            this.state = State.VERIFIED;
        }
        return verified;
    }

    @Override
    public String serialize() {
        this.ensureSignedOrVerifiedState();
        StringBuilder sb = new StringBuilder(this.signingInputString);
        sb.append('.');
        sb.append(this.signature.toString());
        return sb.toString();
    }

    public static JWSObject parse(String s) throws ParseException {
        Base64URL[] parts = JOSEObject.split(s);
        if (parts.length != 3) {
            throw new ParseException("Unexpected number of Base64URL parts, must be three", 0);
        }
        return new JWSObject(parts[0], parts[1], parts[2]);
    }

    public static enum State {
        UNSIGNED,
        SIGNED,
        VERIFIED;

    }
}

