/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestValidateConfiguration {
    @Test
    public void validateConfigurationKeys() {
        Assert.assertEquals((Object)"fs.adl.oauth2.refresh.url", (Object)"fs.adl.oauth2.refresh.url");
        Assert.assertEquals((Object)"fs.adl.oauth2.access.token.provider", (Object)"fs.adl.oauth2.access.token.provider");
        Assert.assertEquals((Object)"fs.adl.oauth2.client.id", (Object)"fs.adl.oauth2.client.id");
        Assert.assertEquals((Object)"fs.adl.oauth2.refresh.token", (Object)"fs.adl.oauth2.refresh.token");
        Assert.assertEquals((Object)"fs.adl.oauth2.credential", (Object)"fs.adl.oauth2.credential");
        Assert.assertEquals((Object)"adl.debug.override.localuserasfileowner", (Object)"adl.debug.override.localuserasfileowner");
        Assert.assertEquals((Object)"fs.adl.oauth2.access.token.provider.type", (Object)"fs.adl.oauth2.access.token.provider.type");
        Assert.assertEquals((Object)"adl.feature.client.cache.readahead", (Object)"adl.feature.client.cache.readahead");
        Assert.assertEquals((Object)"adl.feature.client.cache.drop.behind.writes", (Object)"adl.feature.client.cache.drop.behind.writes");
        Assert.assertEquals((Object)"RefreshToken", (Object)"RefreshToken");
        Assert.assertEquals((Object)"ClientCredential", (Object)"ClientCredential");
        Assert.assertEquals((Object)"adl.enable.client.latency.tracker", (Object)"adl.enable.client.latency.tracker");
        Assert.assertEquals((Object)true, (Object)true);
        Assert.assertEquals((Object)true, (Object)true);
        Assert.assertEquals((Object)"adl.feature.experiment.positional.read.enable", (Object)"adl.feature.experiment.positional.read.enable");
        Assert.assertEquals((long)1L, (long)1L);
        Assert.assertEquals((long)0x10000000L, (long)0x10000000L);
        Assert.assertEquals((Object)false, (Object)false);
        Assert.assertEquals((long)0x400000L, (long)0x400000L);
        Assert.assertEquals((long)0x400000L, (long)0x400000L);
        Assert.assertEquals((Object)"adl.feature.ownerandgroup.enableupn", (Object)"adl.feature.ownerandgroup.enableupn");
        Assert.assertEquals((Object)false, (Object)false);
    }

    @Test
    public void testSetDeprecatedKeys() throws ClassNotFoundException {
        Configuration conf = new Configuration(true);
        this.setDeprecatedKeys(conf);
        Class.forName(AdlFileSystem.class.getName());
        this.assertDeprecatedKeys(conf);
    }

    @Test
    public void testLoadDeprecatedKeys() throws IOException, ClassNotFoundException {
        Configuration saveConf = new Configuration(false);
        this.setDeprecatedKeys(saveConf);
        File testRootDir = GenericTestUtils.getTestDir();
        File confXml = new File(testRootDir, "testLoadDeprecatedKeys.xml");
        FileOutputStream out = new FileOutputStream(confXml);
        saveConf.writeXml((OutputStream)out);
        ((OutputStream)out).close();
        Configuration conf = new Configuration(true);
        conf.addResource(confXml.toURI().toURL());
        conf.get("dummy.key");
        Class.forName(AdlFileSystem.class.getName());
        this.assertDeprecatedKeys(conf);
    }

    @Test
    public void testGetAccountNameFromFQDN() {
        Assert.assertEquals((Object)"dummy", (Object)AdlFileSystem.getAccountNameFromFQDN((String)"dummy.azuredatalakestore.net"));
        Assert.assertEquals((Object)"localhost", (Object)AdlFileSystem.getAccountNameFromFQDN((String)"localhost"));
    }

    @Test
    public void testPropagateAccountOptionsDefault() {
        Configuration conf = new Configuration(false);
        conf.set("fs.adl.oauth2.client.id", "defaultClientId");
        conf.set("fs.adl.oauth2.credential", "defaultCredential");
        conf.set("some.other.config", "someValue");
        Configuration propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"dummy");
        Assert.assertEquals((Object)"defaultClientId", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assert.assertEquals((Object)"defaultCredential", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assert.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
    }

    @Test
    public void testPropagateAccountOptionsSpecified() {
        Configuration conf = new Configuration(false);
        conf.set("fs.adl.account.dummy.oauth2.client.id", "dummyClientId");
        conf.set("fs.adl.account.dummy.oauth2.credential", "dummyCredential");
        conf.set("some.other.config", "someValue");
        Configuration propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"dummy");
        Assert.assertEquals((Object)"dummyClientId", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assert.assertEquals((Object)"dummyCredential", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assert.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
        propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"anotherDummy");
        Assert.assertEquals(null, (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assert.assertEquals(null, (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assert.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
    }

    @Test
    public void testPropagateAccountOptionsAll() {
        Configuration conf = new Configuration(false);
        conf.set("fs.adl.oauth2.client.id", "defaultClientId");
        conf.set("fs.adl.oauth2.credential", "defaultCredential");
        conf.set("some.other.config", "someValue");
        conf.set("fs.adl.account.dummy1.oauth2.client.id", "dummyClientId1");
        conf.set("fs.adl.account.dummy1.oauth2.credential", "dummyCredential1");
        conf.set("fs.adl.account.dummy2.oauth2.client.id", "dummyClientId2");
        conf.set("fs.adl.account.dummy2.oauth2.credential", "dummyCredential2");
        Configuration propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"dummy1");
        Assert.assertEquals((Object)"dummyClientId1", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assert.assertEquals((Object)"dummyCredential1", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assert.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
        propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"dummy2");
        Assert.assertEquals((Object)"dummyClientId2", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assert.assertEquals((Object)"dummyCredential2", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assert.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
        propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"anotherDummy");
        Assert.assertEquals((Object)"defaultClientId", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assert.assertEquals((Object)"defaultCredential", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assert.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
    }

    private void setDeprecatedKeys(Configuration conf) {
        conf.set("dfs.adls.oauth2.access.token.provider.type", "dummyType");
        conf.set("dfs.adls.oauth2.client.id", "dummyClientId");
        conf.set("dfs.adls.oauth2.refresh.token", "dummyRefreshToken");
        conf.set("dfs.adls.oauth2.refresh.url", "dummyRefreshUrl");
        conf.set("dfs.adls.oauth2.credential", "dummyCredential");
        conf.set("dfs.adls.oauth2.access.token.provider", "dummyClass");
        conf.set("adl.dfs.enable.client.latency.tracker", "dummyTracker");
    }

    private void assertDeprecatedKeys(Configuration conf) {
        Assert.assertEquals((Object)"dummyType", (Object)conf.get("fs.adl.oauth2.access.token.provider.type"));
        Assert.assertEquals((Object)"dummyClientId", (Object)conf.get("fs.adl.oauth2.client.id"));
        Assert.assertEquals((Object)"dummyRefreshToken", (Object)conf.get("fs.adl.oauth2.refresh.token"));
        Assert.assertEquals((Object)"dummyRefreshUrl", (Object)conf.get("fs.adl.oauth2.refresh.url"));
        Assert.assertEquals((Object)"dummyCredential", (Object)conf.get("fs.adl.oauth2.credential"));
        Assert.assertEquals((Object)"dummyClass", (Object)conf.get("fs.adl.oauth2.access.token.provider"));
        Assert.assertEquals((Object)"dummyTracker", (Object)conf.get("adl.enable.client.latency.tracker"));
    }
}

