/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.TestAuthenticationFilter;
import org.apache.hadoop.security.authentication.util.Signer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAuthenticationFilter {
    @Test
    public void testGetConfiguration() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("config.prefix")).thenReturn((Object)"");
        Mockito.when((Object)config.getInitParameter("a")).thenReturn((Object)"A");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("a")).elements());
        Properties props = filter.getConfiguration("", config);
        Assert.assertEquals((Object)"A", (Object)props.getProperty("a"));
        config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("config.prefix")).thenReturn((Object)"foo");
        Mockito.when((Object)config.getInitParameter("foo.a")).thenReturn((Object)"A");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("foo.a")).elements());
        props = filter.getConfiguration("foo.", config);
        Assert.assertEquals((Object)"A", (Object)props.getProperty("a"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitEmpty() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector().elements());
            filter.init(config);
            Assert.fail();
        }
        catch (ServletException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInit() throws Exception {
        FilterConfig config;
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)"1000");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity")).elements());
            filter.init(config);
            Assert.assertEquals(PseudoAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
            Assert.assertTrue((boolean)filter.isRandomSecret());
            Assert.assertNull((Object)filter.getCookieDomain());
            Assert.assertNull((Object)filter.getCookiePath());
            Assert.assertEquals((long)1000L, (long)filter.getValidity());
        }
        finally {
            filter.destroy();
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret")).elements());
            filter.init(config);
            Assert.assertFalse((boolean)filter.isRandomSecret());
        }
        finally {
            filter.destroy();
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("cookie.domain")).thenReturn((Object)".foo.com");
            Mockito.when((Object)config.getInitParameter("cookie.path")).thenReturn((Object)"/bar");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "cookie.domain", "cookie.path")).elements());
            filter.init(config);
            Assert.assertEquals((Object)".foo.com", (Object)filter.getCookieDomain());
            Assert.assertEquals((Object)"/bar", (Object)filter.getCookiePath());
        }
        finally {
            filter.destroy();
        }
        DummyAuthenticationHandler.reset();
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            Assert.assertTrue((boolean)DummyAuthenticationHandler.init);
        }
        finally {
            filter.destroy();
            Assert.assertTrue((boolean)DummyAuthenticationHandler.destroy);
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"kerberos");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type")).elements());
            filter.init(config);
        }
        catch (ServletException servletException) {
        }
        finally {
            Assert.assertEquals(KerberosAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRequestURL() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)"a=A&b=B");
            Assert.assertEquals((Object)"http://foo:8080/bar?a=A&b=B", (Object)filter.getRequestURL(request));
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetToken() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            AuthenticationToken newToken = filter.getToken(request);
            Assert.assertEquals((Object)token.toString(), (Object)newToken.toString());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTokenExpired() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() - 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            try {
                filter.getToken(request);
                Assert.fail();
            }
            catch (AuthenticationException ex) {
            }
            catch (Exception ex) {
                Assert.fail();
            }
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTokenInvalidType() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            try {
                filter.getToken(request);
                Assert.fail();
            }
            catch (AuthenticationException ex) {
            }
            catch (Exception ex) {
                Assert.fail();
            }
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterNotAuthenticated() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testDoFilterAuthentication(boolean withDomainPath, boolean invalidToken, boolean expired) throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("expired.token")).thenReturn((Object)Boolean.toString(expired));
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)"1000");
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity", "signature.secret", "management.operation.return", "expired.token")).elements());
            if (withDomainPath) {
                Mockito.when((Object)config.getInitParameter("cookie.domain")).thenReturn((Object)".foo.com");
                Mockito.when((Object)config.getInitParameter("cookie.path")).thenReturn((Object)"/bar");
                Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity", "signature.secret", "cookie.domain", "cookie.path", "management.operation.return")).elements());
            }
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getParameter("authenticated")).thenReturn((Object)"true");
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)"authenticated=true");
            if (invalidToken) {
                Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{new Cookie("hadoop.auth", "foo")});
            }
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            boolean[] calledDoFilter = new boolean[1];
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            Cookie[] setCookie = new Cookie[1];
            ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addCookie((Cookie)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            if (expired) {
                ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).addCookie((Cookie)Mockito.any(Cookie.class));
            } else {
                Assert.assertNotNull((Object)setCookie[0]);
                Assert.assertEquals((Object)"hadoop.auth", (Object)setCookie[0].getName());
                Assert.assertTrue((boolean)setCookie[0].getValue().contains("u="));
                Assert.assertTrue((boolean)setCookie[0].getValue().contains("p="));
                Assert.assertTrue((boolean)setCookie[0].getValue().contains("t="));
                Assert.assertTrue((boolean)setCookie[0].getValue().contains("e="));
                Assert.assertTrue((boolean)setCookie[0].getValue().contains("s="));
                Assert.assertTrue((boolean)calledDoFilter[0]);
                Signer signer = new Signer("secret".getBytes());
                String value = signer.verifyAndExtract(setCookie[0].getValue());
                AuthenticationToken token = AuthenticationToken.parse((String)value);
                Assert.assertEquals((double)(System.currentTimeMillis() + 1000000L), (double)token.getExpires(), (double)100.0);
                if (withDomainPath) {
                    Assert.assertEquals((Object)".foo.com", (Object)setCookie[0].getDomain());
                    Assert.assertEquals((Object)"/bar", (Object)setCookie[0].getPath());
                } else {
                    Assert.assertNull((Object)setCookie[0].getDomain());
                    Assert.assertNull((Object)setCookie[0].getPath());
                }
            }
        }
        finally {
            filter.destroy();
        }
    }

    @Test
    public void testDoFilterAuthentication() throws Exception {
        this._testDoFilterAuthentication(false, false, false);
    }

    @Test
    public void testDoFilterAuthenticationImmediateExpiration() throws Exception {
        this._testDoFilterAuthentication(false, false, true);
    }

    @Test
    public void testDoFilterAuthenticationWithInvalidToken() throws Exception {
        this._testDoFilterAuthentication(false, true, false);
    }

    @Test
    public void testDoFilterAuthenticationWithDomainPath() throws Exception {
        this._testDoFilterAuthentication(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticated() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "t");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticatedExpired() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() - 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            Cookie[] setCookie = new Cookie[1];
            ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addCookie((Cookie)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
            Assert.assertNotNull((Object)setCookie[0]);
            Assert.assertEquals((Object)"hadoop.auth", (Object)setCookie[0].getName());
            Assert.assertEquals((Object)"", (Object)setCookie[0].getValue());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticatedInvalidType() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            Cookie[] setCookie = new Cookie[1];
            ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addCookie((Cookie)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
            Assert.assertNotNull((Object)setCookie[0]);
            Assert.assertEquals((Object)"hadoop.auth", (Object)setCookie[0].getName());
            Assert.assertEquals((Object)"", (Object)setCookie[0].getValue());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagementOperation() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"false");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(202);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
            Mockito.reset((Object[])new HttpServletRequest[]{request});
            Mockito.reset((Object[])new HttpServletResponse[]{response});
            AuthenticationToken token = new AuthenticationToken("u", "p", "t");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(202);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
        }
        finally {
            filter.destroy();
        }
    }
}

