/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.AuthenticatorTestCase;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.junit.Assert;
import org.junit.Test;

public class TestPseudoAuthenticator {
    private Properties getAuthenticationHandlerConfiguration(boolean anonymousAllowed) {
        Properties props = new Properties();
        props.setProperty("type", "simple");
        props.setProperty("simple.anonymous.allowed", Boolean.toString(anonymousAllowed));
        return props;
    }

    @Test
    public void testGetUserName() throws Exception {
        PseudoAuthenticator authenticator = new PseudoAuthenticator();
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)authenticator.getUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnonymousAllowed() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration(true));
        auth.start();
        try {
            URL url = new URL(auth.getBaseURL());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        }
        finally {
            auth.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnonymousDisallowed() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration(false));
        auth.start();
        try {
            URL url = new URL(auth.getBaseURL());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)401L, (long)conn.getResponseCode());
        }
        finally {
            auth.stop();
        }
    }

    @Test
    public void testAuthenticationAnonymousAllowed() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration(true));
        auth._testAuthentication((Authenticator)new PseudoAuthenticator(), false);
    }

    @Test
    public void testAuthenticationAnonymousDisallowed() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration(false));
        auth._testAuthentication((Authenticator)new PseudoAuthenticator(), false);
    }

    @Test
    public void testAuthenticationAnonymousAllowedWithPost() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration(true));
        auth._testAuthentication((Authenticator)new PseudoAuthenticator(), true);
    }

    @Test
    public void testAuthenticationAnonymousDisallowedWithPost() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration(false));
        auth._testAuthentication((Authenticator)new PseudoAuthenticator(), true);
    }
}

