/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Random;
import org.apache.hadoop.security.authentication.util.RolloverSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.TestRandomSignerSecretProvider;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRandomSignerSecretProvider {
    private final int timeout = 100;
    private final long rolloverFrequency = 50L;

    public TestRandomSignerSecretProvider() {
        LogManager.getLogger((String)RolloverSignerSecretProvider.LOG.getName()).setLevel(Level.DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAndRollSecrets() throws Exception {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        byte[] secret1 = this.generateNewSecret(rand);
        byte[] secret2 = this.generateNewSecret(rand);
        byte[] secret3 = this.generateNewSecret(rand);
        MockRandomSignerSecretProvider secretProvider = (MockRandomSignerSecretProvider)Mockito.spy((Object)new MockRandomSignerSecretProvider(this, seed));
        try {
            secretProvider.init(null, null, 50L);
            byte[] currentSecret = secretProvider.getCurrentSecret();
            byte[][] allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret1, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[0]);
            Assert.assertNull((Object)allSecrets[1]);
            ((MockRandomSignerSecretProvider)Mockito.verify((Object)secretProvider, (VerificationMode)Mockito.timeout((int)100).atLeastOnce())).rollSecret();
            secretProvider.realRollSecret();
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret2, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[1]);
            ((MockRandomSignerSecretProvider)Mockito.verify((Object)secretProvider, (VerificationMode)Mockito.timeout((int)100).atLeast(2))).rollSecret();
            secretProvider.realRollSecret();
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret3, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret3, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[1]);
            ((MockRandomSignerSecretProvider)Mockito.verify((Object)secretProvider, (VerificationMode)Mockito.timeout((int)100).atLeast(3))).rollSecret();
            secretProvider.realRollSecret();
        }
        finally {
            secretProvider.destroy();
        }
    }

    private byte[] generateNewSecret(Random rand) {
        byte[] secret = new byte[32];
        rand.nextBytes(secret);
        return secret;
    }
}

