/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.security.authentication.client.AuthenticationException;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthToken
implements Principal {
    private static final String ATTR_SEPARATOR = "&";
    private static final String USER_NAME = "u";
    private static final String PRINCIPAL = "p";
    private static final String MAX_INACTIVES = "i";
    private static final String EXPIRES = "e";
    private static final String TYPE = "t";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("u", "p", "e", "t"));
    private String userName;
    private String principal;
    private String type;
    private long maxInactives;
    private long expires;
    private String tokenStr;
    private static final String ILLEGAL_ARG_MSG = " is NULL, empty or contains a '&'";

    protected AuthToken() {
        this.userName = null;
        this.principal = null;
        this.type = null;
        this.maxInactives = -1L;
        this.expires = -1L;
        this.tokenStr = "ANONYMOUS";
        this.generateToken();
    }

    public AuthToken(String userName, String principal, String type) {
        AuthToken.checkForIllegalArgument((String)userName, (String)"userName");
        AuthToken.checkForIllegalArgument((String)principal, (String)"principal");
        AuthToken.checkForIllegalArgument((String)type, (String)"type");
        this.userName = userName;
        this.principal = principal;
        this.type = type;
        this.maxInactives = -1L;
        this.expires = -1L;
    }

    protected static void checkForIllegalArgument(String value, String name) {
        if (value == null || value.length() == 0 || value.contains("&")) {
            throw new IllegalArgumentException(name + " is NULL, empty or contains a '&'");
        }
    }

    public void setMaxInactives(long interval) {
        this.maxInactives = interval;
    }

    public void setExpires(long expires) {
        this.expires = expires;
        this.generateToken();
    }

    public boolean isExpired() {
        return this.getMaxInactives() != -1L && System.currentTimeMillis() > this.getMaxInactives() || this.getExpires() != -1L && System.currentTimeMillis() > this.getExpires();
    }

    private void generateToken() {
        StringBuffer sb = new StringBuffer();
        sb.append("u").append("=").append(this.getUserName()).append("&");
        sb.append("p").append("=").append(this.getName()).append("&");
        sb.append("t").append("=").append(this.getType()).append("&");
        if (this.getMaxInactives() != -1L) {
            sb.append("i").append("=").append(this.getMaxInactives()).append("&");
        }
        sb.append("e").append("=").append(this.getExpires());
        this.tokenStr = sb.toString();
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getName() {
        return this.principal;
    }

    public String getType() {
        return this.type;
    }

    public long getMaxInactives() {
        return this.maxInactives;
    }

    public long getExpires() {
        return this.expires;
    }

    @Override
    public String toString() {
        return this.tokenStr;
    }

    public static AuthToken parse(String tokenStr) throws AuthenticationException {
        if (tokenStr.length() >= 2 && tokenStr.charAt(0) == '\"' && tokenStr.charAt(tokenStr.length() - 1) == '\"') {
            tokenStr = tokenStr.substring(1, tokenStr.length() - 1);
        }
        Map map = AuthToken.split((String)tokenStr);
        map.remove("s");
        if (!map.keySet().containsAll(ATTRIBUTES)) {
            throw new AuthenticationException("Invalid token string, missing attributes");
        }
        long expires = Long.parseLong((String)map.get("e"));
        AuthToken token = new AuthToken((String)map.get("u"), (String)map.get("p"), (String)map.get("t"));
        if (map.containsKey("i")) {
            long maxInactives = Long.parseLong((String)map.get("i"));
            token.setMaxInactives(maxInactives);
        }
        token.setExpires(expires);
        return token;
    }

    private static Map<String, String> split(String tokenStr) throws AuthenticationException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(tokenStr, "&");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            int separator = part.indexOf(61);
            if (separator == -1) {
                throw new AuthenticationException("Invalid authentication token");
            }
            String key = part.substring(0, separator);
            String value = part.substring(separator + 1);
            map.put(key, value);
        }
        return map;
    }
}

