/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.common.auth.CredentialsProvider;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.aliyun.oss.AliyunCredentialsProvider;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem;
import org.apache.hadoop.security.ProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AliyunOSSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunOSSUtils.class);

    private AliyunOSSUtils() {
    }

    public static String getValueWithKey(Configuration conf, String key) throws IOException {
        try {
            char[] pass = conf.getPassword(key);
            if (pass != null) {
                return new String(pass).trim();
            }
            return "";
        }
        catch (IOException ioe) {
            throw new IOException("Cannot find password option " + key, ioe);
        }
    }

    public static void skipFully(InputStream is, long n) throws IOException {
        long total = 0L;
        long cur = 0L;
        while ((total += (cur = is.skip(n - total))) < n && cur > 0L) {
        }
        if (total < n) {
            throw new IOException("Failed to skip " + n + " bytes, possibly due to EOF.");
        }
    }

    public static long calculatePartSize(long contentLength, long minPartSize) {
        long tmpPartSize = contentLength / 10000L + 1L;
        return Math.max(minPartSize, tmpPartSize);
    }

    public static CredentialsProvider getCredentialsProvider(Configuration conf) throws IOException {
        AliyunCredentialsProvider credentials;
        String className = conf.getTrimmed("fs.oss.credentials.provider");
        if (StringUtils.isEmpty((String)className)) {
            Configuration newConf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, AliyunOSSFileSystem.class);
            credentials = new AliyunCredentialsProvider(newConf);
        } else {
            try {
                LOG.debug("Credential provider class is:" + className);
                Class<?> credClass = Class.forName(className);
                try {
                    credentials = (CredentialsProvider)credClass.getDeclaredConstructor(Configuration.class).newInstance(conf);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    credentials = (CredentialsProvider)credClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException(className + " not found.", e);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IOException(String.format("%s constructor exception.  A class specified in %s must provide an accessible constructor accepting URI and Configuration, or an accessible default constructor.", className, "fs.oss.credentials.provider"), e);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new IOException(className + " instantiation exception.", e);
            }
        }
        return credentials;
    }

    public static String maybeAddTrailingSlash(String key) {
        if (StringUtils.isNotEmpty((String)key) && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }
}

