/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.util.Progressable;

public class AliyunOSSOutputStream
extends OutputStream {
    public static final Log LOG = LogFactory.getLog(AliyunOSSOutputStream.class);
    private AliyunOSSFileSystemStore store;
    private final String key;
    private FileSystem.Statistics statistics;
    private Progressable progress;
    private long partSizeThreshold;
    private LocalDirAllocator dirAlloc;
    private boolean closed;
    private File tmpFile;
    private BufferedOutputStream backupStream;

    public AliyunOSSOutputStream(Configuration conf, AliyunOSSFileSystemStore store, String key, Progressable progress, FileSystem.Statistics statistics) throws IOException {
        this.store = store;
        this.key = key;
        this.progress = progress;
        this.statistics = statistics;
        this.partSizeThreshold = conf.getLong("fs.oss.multipart.upload.threshold", 0x1400000L);
        if (conf.get("fs.oss.buffer.dir") == null) {
            conf.set("fs.oss.buffer.dir", conf.get("hadoop.tmp.dir") + "/oss");
        }
        this.dirAlloc = new LocalDirAllocator("fs.oss.buffer.dir");
        this.tmpFile = this.dirAlloc.createTmpFileForWrite("output-", -1L, conf);
        this.backupStream = new BufferedOutputStream(new FileOutputStream(this.tmpFile));
        this.closed = false;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.backupStream != null) {
            this.backupStream.close();
        }
        long dataLen = this.tmpFile.length();
        try {
            if (dataLen <= this.partSizeThreshold) {
                this.store.uploadObject(this.key, this.tmpFile);
            } else {
                this.store.multipartUploadObject(this.key, this.tmpFile);
            }
        }
        finally {
            if (!this.tmpFile.delete()) {
                LOG.warn((Object)("Can not delete file: " + this.tmpFile));
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.backupStream.flush();
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.backupStream.write(b);
        this.statistics.incrementBytesWritten(1L);
    }
}

