/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.VariableScope;

public class InnerClassNode
extends ClassNode {
    private final ClassNode outerClass;
    private VariableScope scope;
    private boolean anonymous;

    public InnerClassNode(ClassNode outerClass, String name, int modifiers, ClassNode superClass) {
        this(outerClass, name, modifiers, superClass, ClassNode.EMPTY_ARRAY, MixinNode.EMPTY_ARRAY);
    }

    public InnerClassNode(ClassNode outerClass, String name, int modifiers, ClassNode superClass, ClassNode[] interfaces, MixinNode[] mixins) {
        super(name, modifiers, superClass, interfaces, mixins);
        if (outerClass != null) {
            outerClass.addInnerClass(this);
        }
        this.outerClass = outerClass;
    }

    @Override
    public ClassNode getOuterClass() {
        return this.outerClass;
    }

    public ClassNode getOuterMostClass() {
        ClassNode outerClass = this.getOuterClass();
        while (outerClass instanceof InnerClassNode) {
            outerClass = outerClass.getOuterClass();
        }
        return outerClass;
    }

    @Override
    public FieldNode getOuterField(String name) {
        return this.outerClass.getDeclaredField(name);
    }

    public VariableScope getVariableScope() {
        return this.scope;
    }

    public void setVariableScope(VariableScope scope) {
        this.scope = scope;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }
}

