
package org.apache.gobblin.restli.throttling;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;


/**
 * A throttling policy for Gobblin throttling service.
 * 
 */
@Generated(value = "com.linkedin.pegasus.generator.JavaCodeUtil", comments = "Rest.li Data Template. Generated from /Users/abti/IdeaProjects/incubator-gobblin/gobblin-restli/gobblin-throttling-service/gobblin-throttling-service-api/src/main/pegasus/org/apache/gobblin/restli/throttling/Policy.pdsc.", date = "Fri Nov 30 00:16:39 PST 2018")
public class Policy
    extends RecordTemplate
{

    private final static Policy.Fields _fields = new Policy.Fields();
    private final static RecordDataSchema SCHEMA = ((RecordDataSchema) DataTemplateUtil.parseSchema("{\"type\":\"record\",\"name\":\"Policy\",\"namespace\":\"org.apache.gobblin.restli.throttling\",\"doc\":\"A throttling policy for Gobblin throttling service.\",\"fields\":[{\"name\":\"resource\",\"type\":\"string\",\"doc\":\"Resource for which this policy applied.\"},{\"name\":\"policyName\",\"type\":\"string\",\"doc\":\"The name of the policy.\"},{\"name\":\"parameters\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Parameters for this policy.\"},{\"name\":\"metrics\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Metrics for this policy.\"},{\"name\":\"policyDetails\",\"type\":\"string\",\"doc\":\"Human readable policy details.\"}]}"));
    private final static RecordDataSchema.Field FIELD_Resource = SCHEMA.getField("resource");
    private final static RecordDataSchema.Field FIELD_PolicyName = SCHEMA.getField("policyName");
    private final static RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");
    private final static RecordDataSchema.Field FIELD_Metrics = SCHEMA.getField("metrics");
    private final static RecordDataSchema.Field FIELD_PolicyDetails = SCHEMA.getField("policyDetails");

    public Policy() {
        super(new DataMap(), SCHEMA);
    }

    public Policy(DataMap data) {
        super(data, SCHEMA);
    }

    public static Policy.Fields fields() {
        return _fields;
    }

    /**
     * Existence checker for resource
     * 
     * @see Policy.Fields#resource
     */
    public boolean hasResource() {
        return contains(FIELD_Resource);
    }

    /**
     * Remover for resource
     * 
     * @see Policy.Fields#resource
     */
    public void removeResource() {
        remove(FIELD_Resource);
    }

    /**
     * Getter for resource
     * 
     * @see Policy.Fields#resource
     */
    public String getResource(GetMode mode) {
        return obtainDirect(FIELD_Resource, String.class, mode);
    }

    /**
     * Getter for resource
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see Policy.Fields#resource
     */
    @Nonnull
    public String getResource() {
        return obtainDirect(FIELD_Resource, String.class, GetMode.STRICT);
    }

    /**
     * Setter for resource
     * 
     * @see Policy.Fields#resource
     */
    public Policy setResource(String value, SetMode mode) {
        putDirect(FIELD_Resource, String.class, String.class, value, mode);
        return this;
    }

    /**
     * Setter for resource
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see Policy.Fields#resource
     */
    public Policy setResource(
        @Nonnull
        String value) {
        putDirect(FIELD_Resource, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for policyName
     * 
     * @see Policy.Fields#policyName
     */
    public boolean hasPolicyName() {
        return contains(FIELD_PolicyName);
    }

    /**
     * Remover for policyName
     * 
     * @see Policy.Fields#policyName
     */
    public void removePolicyName() {
        remove(FIELD_PolicyName);
    }

    /**
     * Getter for policyName
     * 
     * @see Policy.Fields#policyName
     */
    public String getPolicyName(GetMode mode) {
        return obtainDirect(FIELD_PolicyName, String.class, mode);
    }

    /**
     * Getter for policyName
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see Policy.Fields#policyName
     */
    @Nonnull
    public String getPolicyName() {
        return obtainDirect(FIELD_PolicyName, String.class, GetMode.STRICT);
    }

    /**
     * Setter for policyName
     * 
     * @see Policy.Fields#policyName
     */
    public Policy setPolicyName(String value, SetMode mode) {
        putDirect(FIELD_PolicyName, String.class, String.class, value, mode);
        return this;
    }

    /**
     * Setter for policyName
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see Policy.Fields#policyName
     */
    public Policy setPolicyName(
        @Nonnull
        String value) {
        putDirect(FIELD_PolicyName, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for parameters
     * 
     * @see Policy.Fields#parameters
     */
    public boolean hasParameters() {
        return contains(FIELD_Parameters);
    }

    /**
     * Remover for parameters
     * 
     * @see Policy.Fields#parameters
     */
    public void removeParameters() {
        remove(FIELD_Parameters);
    }

    /**
     * Getter for parameters
     * 
     * @see Policy.Fields#parameters
     */
    public StringMap getParameters(GetMode mode) {
        return obtainWrapped(FIELD_Parameters, StringMap.class, mode);
    }

    /**
     * Getter for parameters
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see Policy.Fields#parameters
     */
    @Nonnull
    public StringMap getParameters() {
        return obtainWrapped(FIELD_Parameters, StringMap.class, GetMode.STRICT);
    }

    /**
     * Setter for parameters
     * 
     * @see Policy.Fields#parameters
     */
    public Policy setParameters(StringMap value, SetMode mode) {
        putWrapped(FIELD_Parameters, StringMap.class, value, mode);
        return this;
    }

    /**
     * Setter for parameters
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see Policy.Fields#parameters
     */
    public Policy setParameters(
        @Nonnull
        StringMap value) {
        putWrapped(FIELD_Parameters, StringMap.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for metrics
     * 
     * @see Policy.Fields#metrics
     */
    public boolean hasMetrics() {
        return contains(FIELD_Metrics);
    }

    /**
     * Remover for metrics
     * 
     * @see Policy.Fields#metrics
     */
    public void removeMetrics() {
        remove(FIELD_Metrics);
    }

    /**
     * Getter for metrics
     * 
     * @see Policy.Fields#metrics
     */
    public StringMap getMetrics(GetMode mode) {
        return obtainWrapped(FIELD_Metrics, StringMap.class, mode);
    }

    /**
     * Getter for metrics
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see Policy.Fields#metrics
     */
    @Nonnull
    public StringMap getMetrics() {
        return obtainWrapped(FIELD_Metrics, StringMap.class, GetMode.STRICT);
    }

    /**
     * Setter for metrics
     * 
     * @see Policy.Fields#metrics
     */
    public Policy setMetrics(StringMap value, SetMode mode) {
        putWrapped(FIELD_Metrics, StringMap.class, value, mode);
        return this;
    }

    /**
     * Setter for metrics
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see Policy.Fields#metrics
     */
    public Policy setMetrics(
        @Nonnull
        StringMap value) {
        putWrapped(FIELD_Metrics, StringMap.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for policyDetails
     * 
     * @see Policy.Fields#policyDetails
     */
    public boolean hasPolicyDetails() {
        return contains(FIELD_PolicyDetails);
    }

    /**
     * Remover for policyDetails
     * 
     * @see Policy.Fields#policyDetails
     */
    public void removePolicyDetails() {
        remove(FIELD_PolicyDetails);
    }

    /**
     * Getter for policyDetails
     * 
     * @see Policy.Fields#policyDetails
     */
    public String getPolicyDetails(GetMode mode) {
        return obtainDirect(FIELD_PolicyDetails, String.class, mode);
    }

    /**
     * Getter for policyDetails
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see Policy.Fields#policyDetails
     */
    @Nonnull
    public String getPolicyDetails() {
        return obtainDirect(FIELD_PolicyDetails, String.class, GetMode.STRICT);
    }

    /**
     * Setter for policyDetails
     * 
     * @see Policy.Fields#policyDetails
     */
    public Policy setPolicyDetails(String value, SetMode mode) {
        putDirect(FIELD_PolicyDetails, String.class, String.class, value, mode);
        return this;
    }

    /**
     * Setter for policyDetails
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see Policy.Fields#policyDetails
     */
    public Policy setPolicyDetails(
        @Nonnull
        String value) {
        putDirect(FIELD_PolicyDetails, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    @Override
    public Policy clone()
        throws CloneNotSupportedException
    {
        return ((Policy) super.clone());
    }

    @Override
    public Policy copy()
        throws CloneNotSupportedException
    {
        return ((Policy) super.copy());
    }

    public static class Fields
        extends PathSpec
    {


        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
            super();
        }

        /**
         * Resource for which this policy applied.
         * 
         */
        public PathSpec resource() {
            return new PathSpec(getPathComponents(), "resource");
        }

        /**
         * The name of the policy.
         * 
         */
        public PathSpec policyName() {
            return new PathSpec(getPathComponents(), "policyName");
        }

        /**
         * Parameters for this policy.
         * 
         */
        public PathSpec parameters() {
            return new PathSpec(getPathComponents(), "parameters");
        }

        /**
         * Metrics for this policy.
         * 
         */
        public PathSpec metrics() {
            return new PathSpec(getPathComponents(), "metrics");
        }

        /**
         * Human readable policy details.
         * 
         */
        public PathSpec policyDetails() {
            return new PathSpec(getPathComponents(), "policyDetails");
        }

    }

}
