
package org.apache.gobblin.restli.throttling;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;


/**
 * Used to request permits from a gobblin-throttling-service.
 * 
 */
@Generated(value = "com.linkedin.pegasus.generator.JavaCodeUtil", comments = "Rest.li Data Template. Generated from /Users/abti/IdeaProjects/incubator-gobblin/gobblin-restli/gobblin-throttling-service/gobblin-throttling-service-api/src/main/pegasus/org/apache/gobblin/restli/throttling/PermitRequest.pdsc.", date = "Fri Nov 30 00:16:39 PST 2018")
public class PermitRequest
    extends RecordTemplate
{

    private final static PermitRequest.Fields _fields = new PermitRequest.Fields();
    private final static RecordDataSchema SCHEMA = ((RecordDataSchema) DataTemplateUtil.parseSchema("{\"type\":\"record\",\"name\":\"PermitRequest\",\"namespace\":\"org.apache.gobblin.restli.throttling\",\"doc\":\"Used to request permits from a gobblin-throttling-service.\",\"fields\":[{\"name\":\"resource\",\"type\":\"string\",\"doc\":\"Resource for which permits are needed.\"},{\"name\":\"permits\",\"type\":\"long\",\"doc\":\"Number of permits needed.\"},{\"name\":\"minPermits\",\"type\":\"long\",\"doc\":\"Minimum number of useful permits.\",\"optional\":true},{\"name\":\"requestorIdentifier\",\"type\":\"string\",\"doc\":\"Identifier of the service requesting the permits.\"}]}"));
    private final static RecordDataSchema.Field FIELD_Resource = SCHEMA.getField("resource");
    private final static RecordDataSchema.Field FIELD_Permits = SCHEMA.getField("permits");
    private final static RecordDataSchema.Field FIELD_MinPermits = SCHEMA.getField("minPermits");
    private final static RecordDataSchema.Field FIELD_RequestorIdentifier = SCHEMA.getField("requestorIdentifier");

    public PermitRequest() {
        super(new DataMap(), SCHEMA);
    }

    public PermitRequest(DataMap data) {
        super(data, SCHEMA);
    }

    public static PermitRequest.Fields fields() {
        return _fields;
    }

    /**
     * Existence checker for resource
     * 
     * @see PermitRequest.Fields#resource
     */
    public boolean hasResource() {
        return contains(FIELD_Resource);
    }

    /**
     * Remover for resource
     * 
     * @see PermitRequest.Fields#resource
     */
    public void removeResource() {
        remove(FIELD_Resource);
    }

    /**
     * Getter for resource
     * 
     * @see PermitRequest.Fields#resource
     */
    public String getResource(GetMode mode) {
        return obtainDirect(FIELD_Resource, String.class, mode);
    }

    /**
     * Getter for resource
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see PermitRequest.Fields#resource
     */
    @Nonnull
    public String getResource() {
        return obtainDirect(FIELD_Resource, String.class, GetMode.STRICT);
    }

    /**
     * Setter for resource
     * 
     * @see PermitRequest.Fields#resource
     */
    public PermitRequest setResource(String value, SetMode mode) {
        putDirect(FIELD_Resource, String.class, String.class, value, mode);
        return this;
    }

    /**
     * Setter for resource
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see PermitRequest.Fields#resource
     */
    public PermitRequest setResource(
        @Nonnull
        String value) {
        putDirect(FIELD_Resource, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for permits
     * 
     * @see PermitRequest.Fields#permits
     */
    public boolean hasPermits() {
        return contains(FIELD_Permits);
    }

    /**
     * Remover for permits
     * 
     * @see PermitRequest.Fields#permits
     */
    public void removePermits() {
        remove(FIELD_Permits);
    }

    /**
     * Getter for permits
     * 
     * @see PermitRequest.Fields#permits
     */
    public Long getPermits(GetMode mode) {
        return obtainDirect(FIELD_Permits, Long.class, mode);
    }

    /**
     * Getter for permits
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see PermitRequest.Fields#permits
     */
    @Nonnull
    public Long getPermits() {
        return obtainDirect(FIELD_Permits, Long.class, GetMode.STRICT);
    }

    /**
     * Setter for permits
     * 
     * @see PermitRequest.Fields#permits
     */
    public PermitRequest setPermits(Long value, SetMode mode) {
        putDirect(FIELD_Permits, Long.class, Long.class, value, mode);
        return this;
    }

    /**
     * Setter for permits
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see PermitRequest.Fields#permits
     */
    public PermitRequest setPermits(
        @Nonnull
        Long value) {
        putDirect(FIELD_Permits, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Setter for permits
     * 
     * @see PermitRequest.Fields#permits
     */
    public PermitRequest setPermits(long value) {
        putDirect(FIELD_Permits, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for minPermits
     * 
     * @see PermitRequest.Fields#minPermits
     */
    public boolean hasMinPermits() {
        return contains(FIELD_MinPermits);
    }

    /**
     * Remover for minPermits
     * 
     * @see PermitRequest.Fields#minPermits
     */
    public void removeMinPermits() {
        remove(FIELD_MinPermits);
    }

    /**
     * Getter for minPermits
     * 
     * @see PermitRequest.Fields#minPermits
     */
    public Long getMinPermits(GetMode mode) {
        return obtainDirect(FIELD_MinPermits, Long.class, mode);
    }

    /**
     * Getter for minPermits
     * 
     * @return
     *     Optional field. Always check for null.
     * @see PermitRequest.Fields#minPermits
     */
    @Nullable
    public Long getMinPermits() {
        return obtainDirect(FIELD_MinPermits, Long.class, GetMode.STRICT);
    }

    /**
     * Setter for minPermits
     * 
     * @see PermitRequest.Fields#minPermits
     */
    public PermitRequest setMinPermits(Long value, SetMode mode) {
        putDirect(FIELD_MinPermits, Long.class, Long.class, value, mode);
        return this;
    }

    /**
     * Setter for minPermits
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see PermitRequest.Fields#minPermits
     */
    public PermitRequest setMinPermits(
        @Nonnull
        Long value) {
        putDirect(FIELD_MinPermits, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Setter for minPermits
     * 
     * @see PermitRequest.Fields#minPermits
     */
    public PermitRequest setMinPermits(long value) {
        putDirect(FIELD_MinPermits, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for requestorIdentifier
     * 
     * @see PermitRequest.Fields#requestorIdentifier
     */
    public boolean hasRequestorIdentifier() {
        return contains(FIELD_RequestorIdentifier);
    }

    /**
     * Remover for requestorIdentifier
     * 
     * @see PermitRequest.Fields#requestorIdentifier
     */
    public void removeRequestorIdentifier() {
        remove(FIELD_RequestorIdentifier);
    }

    /**
     * Getter for requestorIdentifier
     * 
     * @see PermitRequest.Fields#requestorIdentifier
     */
    public String getRequestorIdentifier(GetMode mode) {
        return obtainDirect(FIELD_RequestorIdentifier, String.class, mode);
    }

    /**
     * Getter for requestorIdentifier
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see PermitRequest.Fields#requestorIdentifier
     */
    @Nonnull
    public String getRequestorIdentifier() {
        return obtainDirect(FIELD_RequestorIdentifier, String.class, GetMode.STRICT);
    }

    /**
     * Setter for requestorIdentifier
     * 
     * @see PermitRequest.Fields#requestorIdentifier
     */
    public PermitRequest setRequestorIdentifier(String value, SetMode mode) {
        putDirect(FIELD_RequestorIdentifier, String.class, String.class, value, mode);
        return this;
    }

    /**
     * Setter for requestorIdentifier
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see PermitRequest.Fields#requestorIdentifier
     */
    public PermitRequest setRequestorIdentifier(
        @Nonnull
        String value) {
        putDirect(FIELD_RequestorIdentifier, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    @Override
    public PermitRequest clone()
        throws CloneNotSupportedException
    {
        return ((PermitRequest) super.clone());
    }

    @Override
    public PermitRequest copy()
        throws CloneNotSupportedException
    {
        return ((PermitRequest) super.copy());
    }

    public static class Fields
        extends PathSpec
    {


        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
            super();
        }

        /**
         * Resource for which permits are needed.
         * 
         */
        public PathSpec resource() {
            return new PathSpec(getPathComponents(), "resource");
        }

        /**
         * Number of permits needed.
         * 
         */
        public PathSpec permits() {
            return new PathSpec(getPathComponents(), "permits");
        }

        /**
         * Minimum number of useful permits.
         * 
         */
        public PathSpec minPermits() {
            return new PathSpec(getPathComponents(), "minPermits");
        }

        /**
         * Identifier of the service requesting the permits.
         * 
         */
        public PathSpec requestorIdentifier() {
            return new PathSpec(getPathComponents(), "requestorIdentifier");
        }

    }

}
