
package org.apache.gobblin.restli.throttling;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;


/**
 * Used by gobblin-throttling-service to allocate permits to a client.
 * 
 */
@Generated(value = "com.linkedin.pegasus.generator.JavaCodeUtil", comments = "Rest.li Data Template. Generated from /Users/abti/IdeaProjects/incubator-gobblin/gobblin-restli/gobblin-throttling-service/gobblin-throttling-service-api/src/main/pegasus/org/apache/gobblin/restli/throttling/PermitAllocation.pdsc.", date = "Fri Nov 30 00:16:39 PST 2018")
public class PermitAllocation
    extends RecordTemplate
{

    private final static PermitAllocation.Fields _fields = new PermitAllocation.Fields();
    private final static RecordDataSchema SCHEMA = ((RecordDataSchema) DataTemplateUtil.parseSchema("{\"type\":\"record\",\"name\":\"PermitAllocation\",\"namespace\":\"org.apache.gobblin.restli.throttling\",\"doc\":\"Used by gobblin-throttling-service to allocate permits to a client.\",\"fields\":[{\"name\":\"permits\",\"type\":\"long\",\"doc\":\"Number of permits allocated. This may be 0 if no permits are allocated, or the number of requested permits.\"},{\"name\":\"expiration\",\"type\":\"long\",\"doc\":\"Expiration time in Unix timestamp of the allocated permits.\"},{\"name\":\"minRetryDelayMillis\",\"type\":\"long\",\"doc\":\"Client should not try to acquire permits before this delay has passed.\",\"optional\":true}]}"));
    private final static RecordDataSchema.Field FIELD_Permits = SCHEMA.getField("permits");
    private final static RecordDataSchema.Field FIELD_Expiration = SCHEMA.getField("expiration");
    private final static RecordDataSchema.Field FIELD_MinRetryDelayMillis = SCHEMA.getField("minRetryDelayMillis");

    public PermitAllocation() {
        super(new DataMap(), SCHEMA);
    }

    public PermitAllocation(DataMap data) {
        super(data, SCHEMA);
    }

    public static PermitAllocation.Fields fields() {
        return _fields;
    }

    /**
     * Existence checker for permits
     * 
     * @see PermitAllocation.Fields#permits
     */
    public boolean hasPermits() {
        return contains(FIELD_Permits);
    }

    /**
     * Remover for permits
     * 
     * @see PermitAllocation.Fields#permits
     */
    public void removePermits() {
        remove(FIELD_Permits);
    }

    /**
     * Getter for permits
     * 
     * @see PermitAllocation.Fields#permits
     */
    public Long getPermits(GetMode mode) {
        return obtainDirect(FIELD_Permits, Long.class, mode);
    }

    /**
     * Getter for permits
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see PermitAllocation.Fields#permits
     */
    @Nonnull
    public Long getPermits() {
        return obtainDirect(FIELD_Permits, Long.class, GetMode.STRICT);
    }

    /**
     * Setter for permits
     * 
     * @see PermitAllocation.Fields#permits
     */
    public PermitAllocation setPermits(Long value, SetMode mode) {
        putDirect(FIELD_Permits, Long.class, Long.class, value, mode);
        return this;
    }

    /**
     * Setter for permits
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see PermitAllocation.Fields#permits
     */
    public PermitAllocation setPermits(
        @Nonnull
        Long value) {
        putDirect(FIELD_Permits, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Setter for permits
     * 
     * @see PermitAllocation.Fields#permits
     */
    public PermitAllocation setPermits(long value) {
        putDirect(FIELD_Permits, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for expiration
     * 
     * @see PermitAllocation.Fields#expiration
     */
    public boolean hasExpiration() {
        return contains(FIELD_Expiration);
    }

    /**
     * Remover for expiration
     * 
     * @see PermitAllocation.Fields#expiration
     */
    public void removeExpiration() {
        remove(FIELD_Expiration);
    }

    /**
     * Getter for expiration
     * 
     * @see PermitAllocation.Fields#expiration
     */
    public Long getExpiration(GetMode mode) {
        return obtainDirect(FIELD_Expiration, Long.class, mode);
    }

    /**
     * Getter for expiration
     * 
     * @return
     *     Required field. Could be null for partial record.
     * @see PermitAllocation.Fields#expiration
     */
    @Nonnull
    public Long getExpiration() {
        return obtainDirect(FIELD_Expiration, Long.class, GetMode.STRICT);
    }

    /**
     * Setter for expiration
     * 
     * @see PermitAllocation.Fields#expiration
     */
    public PermitAllocation setExpiration(Long value, SetMode mode) {
        putDirect(FIELD_Expiration, Long.class, Long.class, value, mode);
        return this;
    }

    /**
     * Setter for expiration
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see PermitAllocation.Fields#expiration
     */
    public PermitAllocation setExpiration(
        @Nonnull
        Long value) {
        putDirect(FIELD_Expiration, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Setter for expiration
     * 
     * @see PermitAllocation.Fields#expiration
     */
    public PermitAllocation setExpiration(long value) {
        putDirect(FIELD_Expiration, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Existence checker for minRetryDelayMillis
     * 
     * @see PermitAllocation.Fields#minRetryDelayMillis
     */
    public boolean hasMinRetryDelayMillis() {
        return contains(FIELD_MinRetryDelayMillis);
    }

    /**
     * Remover for minRetryDelayMillis
     * 
     * @see PermitAllocation.Fields#minRetryDelayMillis
     */
    public void removeMinRetryDelayMillis() {
        remove(FIELD_MinRetryDelayMillis);
    }

    /**
     * Getter for minRetryDelayMillis
     * 
     * @see PermitAllocation.Fields#minRetryDelayMillis
     */
    public Long getMinRetryDelayMillis(GetMode mode) {
        return obtainDirect(FIELD_MinRetryDelayMillis, Long.class, mode);
    }

    /**
     * Getter for minRetryDelayMillis
     * 
     * @return
     *     Optional field. Always check for null.
     * @see PermitAllocation.Fields#minRetryDelayMillis
     */
    @Nullable
    public Long getMinRetryDelayMillis() {
        return obtainDirect(FIELD_MinRetryDelayMillis, Long.class, GetMode.STRICT);
    }

    /**
     * Setter for minRetryDelayMillis
     * 
     * @see PermitAllocation.Fields#minRetryDelayMillis
     */
    public PermitAllocation setMinRetryDelayMillis(Long value, SetMode mode) {
        putDirect(FIELD_MinRetryDelayMillis, Long.class, Long.class, value, mode);
        return this;
    }

    /**
     * Setter for minRetryDelayMillis
     * 
     * @param value
     *     Must not be null. For more control, use setters with mode instead.
     * @see PermitAllocation.Fields#minRetryDelayMillis
     */
    public PermitAllocation setMinRetryDelayMillis(
        @Nonnull
        Long value) {
        putDirect(FIELD_MinRetryDelayMillis, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    /**
     * Setter for minRetryDelayMillis
     * 
     * @see PermitAllocation.Fields#minRetryDelayMillis
     */
    public PermitAllocation setMinRetryDelayMillis(long value) {
        putDirect(FIELD_MinRetryDelayMillis, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    @Override
    public PermitAllocation clone()
        throws CloneNotSupportedException
    {
        return ((PermitAllocation) super.clone());
    }

    @Override
    public PermitAllocation copy()
        throws CloneNotSupportedException
    {
        return ((PermitAllocation) super.copy());
    }

    public static class Fields
        extends PathSpec
    {


        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
            super();
        }

        /**
         * Number of permits allocated. This may be 0 if no permits are allocated, or the number of requested permits.
         * 
         */
        public PathSpec permits() {
            return new PathSpec(getPathComponents(), "permits");
        }

        /**
         * Expiration time in Unix timestamp of the allocated permits.
         * 
         */
        public PathSpec expiration() {
            return new PathSpec(getPathComponents(), "expiration");
        }

        /**
         * Client should not try to acquire permits before this delay has passed.
         * 
         */
        public PathSpec minRetryDelayMillis() {
            return new PathSpec(getPathComponents(), "minRetryDelayMillis");
        }

    }

}
