/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.gobblin.rest.MetricArray;
import org.apache.gobblin.rest.Table;
import org.apache.gobblin.rest.TaskStateEnum;

public class TaskExecutionInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"TaskExecutionInfo\",\"namespace\":\"org.apache.gobblin.rest\",\"doc\":\"Gobblin task execution information\",\"fields\":[{\"name\":\"jobId\",\"type\":\"string\",\"doc\":\"Job ID\"},{\"name\":\"taskId\",\"type\":\"string\",\"doc\":\"Task ID\"},{\"name\":\"startTime\",\"type\":\"long\",\"doc\":\"Task start time (epoch time)\",\"optional\":true},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"Task end time (epoch time)\",\"optional\":true},{\"name\":\"duration\",\"type\":\"long\",\"doc\":\"Task duration in milliseconds\",\"optional\":true},{\"name\":\"state\",\"type\":{\"type\":\"enum\",\"name\":\"TaskStateEnum\",\"symbols\":[\"PENDING\",\"RUNNING\",\"SUCCESSFUL\",\"COMMITTED\",\"FAILED\",\"CANCELLED\"]},\"doc\":\"Task state\",\"optional\":true},{\"name\":\"failureException\",\"type\":\"string\",\"doc\":\"Task failure exception message\",\"optional\":true},{\"name\":\"lowWatermark\",\"type\":\"long\",\"doc\":\"Low watermark\",\"optional\":true},{\"name\":\"highWatermark\",\"type\":\"long\",\"doc\":\"High watermark\",\"optional\":true},{\"name\":\"table\",\"type\":{\"type\":\"record\",\"name\":\"Table\",\"doc\":\"Gobblin table definition\",\"fields\":[{\"name\":\"namespace\",\"type\":\"string\",\"doc\":\"Table namespace\",\"optional\":true},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Table name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"TableTypeEnum\",\"symbols\":[\"SNAPSHOT_ONLY\",\"SNAPSHOT_APPEND\",\"APPEND_ONLY\"]},\"doc\":\"Table type\",\"optional\":true}]},\"doc\":\"Table definition\",\"optional\":true},{\"name\":\"taskProperties\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Task properties\",\"optional\":true},{\"name\":\"metrics\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Metric\",\"doc\":\"Gobblin metric\",\"fields\":[{\"name\":\"group\",\"type\":\"string\",\"doc\":\"Metric group\"},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Metric name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"MetricTypeEnum\",\"symbols\":[\"COUNTER\",\"METER\",\"GAUGE\"]},\"doc\":\"Metric type\"},{\"name\":\"value\",\"type\":\"string\",\"doc\":\"Metric value\"}]}},\"doc\":\"Job metrics\"}]}");
    private static final RecordDataSchema.Field FIELD_JobId = SCHEMA.getField("jobId");
    private static final RecordDataSchema.Field FIELD_TaskId = SCHEMA.getField("taskId");
    private static final RecordDataSchema.Field FIELD_StartTime = SCHEMA.getField("startTime");
    private static final RecordDataSchema.Field FIELD_EndTime = SCHEMA.getField("endTime");
    private static final RecordDataSchema.Field FIELD_Duration = SCHEMA.getField("duration");
    private static final RecordDataSchema.Field FIELD_State = SCHEMA.getField("state");
    private static final RecordDataSchema.Field FIELD_FailureException = SCHEMA.getField("failureException");
    private static final RecordDataSchema.Field FIELD_LowWatermark = SCHEMA.getField("lowWatermark");
    private static final RecordDataSchema.Field FIELD_HighWatermark = SCHEMA.getField("highWatermark");
    private static final RecordDataSchema.Field FIELD_Table = SCHEMA.getField("table");
    private static final RecordDataSchema.Field FIELD_TaskProperties = SCHEMA.getField("taskProperties");
    private static final RecordDataSchema.Field FIELD_Metrics = SCHEMA.getField("metrics");

    public TaskExecutionInfo() {
        super(new DataMap(), SCHEMA);
    }

    public TaskExecutionInfo(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasJobId() {
        return this.contains(FIELD_JobId);
    }

    public void removeJobId() {
        this.remove(FIELD_JobId);
    }

    public String getJobId(GetMode mode) {
        return (String)this.obtainDirect(FIELD_JobId, String.class, mode);
    }

    @Nonnull
    public String getJobId() {
        return (String)this.obtainDirect(FIELD_JobId, String.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setJobId(String value, SetMode mode) {
        this.putDirect(FIELD_JobId, String.class, String.class, value, mode);
        return this;
    }

    public TaskExecutionInfo setJobId(@Nonnull String value) {
        this.putDirect(FIELD_JobId, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTaskId() {
        return this.contains(FIELD_TaskId);
    }

    public void removeTaskId() {
        this.remove(FIELD_TaskId);
    }

    public String getTaskId(GetMode mode) {
        return (String)this.obtainDirect(FIELD_TaskId, String.class, mode);
    }

    @Nonnull
    public String getTaskId() {
        return (String)this.obtainDirect(FIELD_TaskId, String.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setTaskId(String value, SetMode mode) {
        this.putDirect(FIELD_TaskId, String.class, String.class, value, mode);
        return this;
    }

    public TaskExecutionInfo setTaskId(@Nonnull String value) {
        this.putDirect(FIELD_TaskId, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasStartTime() {
        return this.contains(FIELD_StartTime);
    }

    public void removeStartTime() {
        this.remove(FIELD_StartTime);
    }

    public Long getStartTime(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_StartTime, Long.class, mode);
    }

    @Nullable
    public Long getStartTime() {
        return (Long)this.obtainDirect(FIELD_StartTime, Long.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setStartTime(Long value, SetMode mode) {
        this.putDirect(FIELD_StartTime, Long.class, Long.class, value, mode);
        return this;
    }

    public TaskExecutionInfo setStartTime(@Nonnull Long value) {
        this.putDirect(FIELD_StartTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public TaskExecutionInfo setStartTime(long value) {
        this.putDirect(FIELD_StartTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasEndTime() {
        return this.contains(FIELD_EndTime);
    }

    public void removeEndTime() {
        this.remove(FIELD_EndTime);
    }

    public Long getEndTime(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_EndTime, Long.class, mode);
    }

    @Nullable
    public Long getEndTime() {
        return (Long)this.obtainDirect(FIELD_EndTime, Long.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setEndTime(Long value, SetMode mode) {
        this.putDirect(FIELD_EndTime, Long.class, Long.class, value, mode);
        return this;
    }

    public TaskExecutionInfo setEndTime(@Nonnull Long value) {
        this.putDirect(FIELD_EndTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public TaskExecutionInfo setEndTime(long value) {
        this.putDirect(FIELD_EndTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDuration() {
        return this.contains(FIELD_Duration);
    }

    public void removeDuration() {
        this.remove(FIELD_Duration);
    }

    public Long getDuration(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_Duration, Long.class, mode);
    }

    @Nullable
    public Long getDuration() {
        return (Long)this.obtainDirect(FIELD_Duration, Long.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setDuration(Long value, SetMode mode) {
        this.putDirect(FIELD_Duration, Long.class, Long.class, value, mode);
        return this;
    }

    public TaskExecutionInfo setDuration(@Nonnull Long value) {
        this.putDirect(FIELD_Duration, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public TaskExecutionInfo setDuration(long value) {
        this.putDirect(FIELD_Duration, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasState() {
        return this.contains(FIELD_State);
    }

    public void removeState() {
        this.remove(FIELD_State);
    }

    public TaskStateEnum getState(GetMode mode) {
        return (TaskStateEnum)((Object)this.obtainDirect(FIELD_State, TaskStateEnum.class, mode));
    }

    @Nullable
    public TaskStateEnum getState() {
        return (TaskStateEnum)((Object)this.obtainDirect(FIELD_State, TaskStateEnum.class, GetMode.STRICT));
    }

    public TaskExecutionInfo setState(TaskStateEnum value, SetMode mode) {
        this.putDirect(FIELD_State, TaskStateEnum.class, String.class, (Object)value, mode);
        return this;
    }

    public TaskExecutionInfo setState(@Nonnull TaskStateEnum value) {
        this.putDirect(FIELD_State, TaskStateEnum.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasFailureException() {
        return this.contains(FIELD_FailureException);
    }

    public void removeFailureException() {
        this.remove(FIELD_FailureException);
    }

    public String getFailureException(GetMode mode) {
        return (String)this.obtainDirect(FIELD_FailureException, String.class, mode);
    }

    @Nullable
    public String getFailureException() {
        return (String)this.obtainDirect(FIELD_FailureException, String.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setFailureException(String value, SetMode mode) {
        this.putDirect(FIELD_FailureException, String.class, String.class, value, mode);
        return this;
    }

    public TaskExecutionInfo setFailureException(@Nonnull String value) {
        this.putDirect(FIELD_FailureException, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLowWatermark() {
        return this.contains(FIELD_LowWatermark);
    }

    public void removeLowWatermark() {
        this.remove(FIELD_LowWatermark);
    }

    public Long getLowWatermark(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_LowWatermark, Long.class, mode);
    }

    @Nullable
    public Long getLowWatermark() {
        return (Long)this.obtainDirect(FIELD_LowWatermark, Long.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setLowWatermark(Long value, SetMode mode) {
        this.putDirect(FIELD_LowWatermark, Long.class, Long.class, value, mode);
        return this;
    }

    public TaskExecutionInfo setLowWatermark(@Nonnull Long value) {
        this.putDirect(FIELD_LowWatermark, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public TaskExecutionInfo setLowWatermark(long value) {
        this.putDirect(FIELD_LowWatermark, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHighWatermark() {
        return this.contains(FIELD_HighWatermark);
    }

    public void removeHighWatermark() {
        this.remove(FIELD_HighWatermark);
    }

    public Long getHighWatermark(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_HighWatermark, Long.class, mode);
    }

    @Nullable
    public Long getHighWatermark() {
        return (Long)this.obtainDirect(FIELD_HighWatermark, Long.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setHighWatermark(Long value, SetMode mode) {
        this.putDirect(FIELD_HighWatermark, Long.class, Long.class, value, mode);
        return this;
    }

    public TaskExecutionInfo setHighWatermark(@Nonnull Long value) {
        this.putDirect(FIELD_HighWatermark, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public TaskExecutionInfo setHighWatermark(long value) {
        this.putDirect(FIELD_HighWatermark, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTable() {
        return this.contains(FIELD_Table);
    }

    public void removeTable() {
        this.remove(FIELD_Table);
    }

    public Table getTable(GetMode mode) {
        return (Table)this.obtainWrapped(FIELD_Table, Table.class, mode);
    }

    @Nullable
    public Table getTable() {
        return (Table)this.obtainWrapped(FIELD_Table, Table.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setTable(Table value, SetMode mode) {
        this.putWrapped(FIELD_Table, Table.class, (DataTemplate)value, mode);
        return this;
    }

    public TaskExecutionInfo setTable(@Nonnull Table value) {
        this.putWrapped(FIELD_Table, Table.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTaskProperties() {
        return this.contains(FIELD_TaskProperties);
    }

    public void removeTaskProperties() {
        this.remove(FIELD_TaskProperties);
    }

    public StringMap getTaskProperties(GetMode mode) {
        return (StringMap)this.obtainWrapped(FIELD_TaskProperties, StringMap.class, mode);
    }

    @Nullable
    public StringMap getTaskProperties() {
        return (StringMap)this.obtainWrapped(FIELD_TaskProperties, StringMap.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setTaskProperties(StringMap value, SetMode mode) {
        this.putWrapped(FIELD_TaskProperties, StringMap.class, (DataTemplate)value, mode);
        return this;
    }

    public TaskExecutionInfo setTaskProperties(@Nonnull StringMap value) {
        this.putWrapped(FIELD_TaskProperties, StringMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMetrics() {
        return this.contains(FIELD_Metrics);
    }

    public void removeMetrics() {
        this.remove(FIELD_Metrics);
    }

    public MetricArray getMetrics(GetMode mode) {
        return (MetricArray)this.obtainWrapped(FIELD_Metrics, MetricArray.class, mode);
    }

    @Nonnull
    public MetricArray getMetrics() {
        return (MetricArray)this.obtainWrapped(FIELD_Metrics, MetricArray.class, GetMode.STRICT);
    }

    public TaskExecutionInfo setMetrics(MetricArray value, SetMode mode) {
        this.putWrapped(FIELD_Metrics, MetricArray.class, (DataTemplate)value, mode);
        return this;
    }

    public TaskExecutionInfo setMetrics(@Nonnull MetricArray value) {
        this.putWrapped(FIELD_Metrics, MetricArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public TaskExecutionInfo clone() throws CloneNotSupportedException {
        return (TaskExecutionInfo)super.clone();
    }

    public TaskExecutionInfo copy() throws CloneNotSupportedException {
        return (TaskExecutionInfo)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec jobId() {
            return new PathSpec(this.getPathComponents(), "jobId");
        }

        public PathSpec taskId() {
            return new PathSpec(this.getPathComponents(), "taskId");
        }

        public PathSpec startTime() {
            return new PathSpec(this.getPathComponents(), "startTime");
        }

        public PathSpec endTime() {
            return new PathSpec(this.getPathComponents(), "endTime");
        }

        public PathSpec duration() {
            return new PathSpec(this.getPathComponents(), "duration");
        }

        public PathSpec state() {
            return new PathSpec(this.getPathComponents(), "state");
        }

        public PathSpec failureException() {
            return new PathSpec(this.getPathComponents(), "failureException");
        }

        public PathSpec lowWatermark() {
            return new PathSpec(this.getPathComponents(), "lowWatermark");
        }

        public PathSpec highWatermark() {
            return new PathSpec(this.getPathComponents(), "highWatermark");
        }

        public Table.Fields table() {
            return new Table.Fields(this.getPathComponents(), "table");
        }

        public PathSpec taskProperties() {
            return new PathSpec(this.getPathComponents(), "taskProperties");
        }

        public MetricArray.Fields metrics() {
            return new MetricArray.Fields(this.getPathComponents(), "metrics");
        }
    }
}

