/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.binary_creation;

import com.google.common.collect.AbstractIterator;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.gobblin.binary_creation.AvroTestTools;
import org.apache.gobblin.binary_creation.DataTestTools;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.filters.HiddenFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroObjectInspectorGenerator;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcTestTools
extends DataTestTools<OrcRowIterator, TypeInfo> {
    private static final Logger log = LoggerFactory.getLogger(OrcTestTools.class);

    @Override
    public boolean checkSameFilesAndRecords(TreeMap<String, OrcRowIterator> expected, TreeMap<String, OrcRowIterator> observed, boolean allowDifferentOrder, Collection<String> blacklistRecordFields, boolean allowDifferentSchema) {
        Iterator<String> keys1 = expected.navigableKeySet().iterator();
        Iterator<String> keys2 = observed.navigableKeySet().iterator();
        return this.compareIterators(keys1, keys2, (key1, key2) -> {
            if (!AvroTestTools.removeExtension(key1).equals(key2)) {
                log.error(String.format("Mismatched files: %s and %s", key1, key2));
                return false;
            }
            OrcRowIterator it1 = (OrcRowIterator)expected.get(key1);
            OrcRowIterator it2 = (OrcRowIterator)observed.get(key2);
            if (!it1.getTypeInfo().equals((Object)it2.getTypeInfo())) {
                log.error(String.format("Mismatched Typeinfo: %s and %s", key1, key2));
                return false;
            }
            boolean result = true;
            while (it1.hasNext()) {
                if (!it2.hasNext() || !result) {
                    return false;
                }
                result = this.compareJavaRowAndOrcStruct(((AvroRow)it1.next()).getRow(), (OrcStruct)it2.next());
            }
            return result;
        });
    }

    private boolean compareJavaRowAndOrcStruct(Object realRow, OrcStruct struct) {
        boolean isIdentical = true;
        ArrayList javaObjRow = (ArrayList)realRow;
        try {
            Field objectArr = OrcStruct.class.getDeclaredField("fields");
            objectArr.setAccessible(true);
            Object[] dataArr = (Object[])objectArr.get(struct);
            int index = 0;
            for (Object dataField : dataArr) {
                isIdentical = dataField instanceof OrcStruct ? isIdentical && this.compareJavaRowAndOrcStruct(javaObjRow.get(index), (OrcStruct)dataField) : isIdentical && this.objCastHelper(javaObjRow.get(index), (Writable)dataField);
                ++index;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException nfe) {
            throw new RuntimeException("Failed in compare a java object row and orcstruct");
        }
        return isIdentical;
    }

    private boolean objCastHelper(Object javaObj, Writable obj) {
        if (obj instanceof IntWritable) {
            return ((IntWritable)obj).get() == ((Integer)javaObj).intValue();
        }
        if (obj instanceof Text) {
            return obj.toString().equals(javaObj);
        }
        if (obj instanceof LongWritable) {
            return ((LongWritable)obj).get() == ((Long)javaObj).longValue();
        }
        if (obj instanceof ShortWritable) {
            return ((ShortWritable)obj).get() == ((Short)javaObj).shortValue();
        }
        if (obj instanceof DoubleWritable) {
            return ((DoubleWritable)obj).get() == ((Double)javaObj).doubleValue();
        }
        throw new RuntimeException("Cannot recognize the writable type, please enrich the castHelper function");
    }

    @Override
    public TypeInfo writeJsonResourceRecordsAsBinary(String baseResource, @Nullable FileSystem fs, Path targetPath, @Nullable TypeInfo schema) throws IOException {
        TreeMap<String, OrcRowIterator> recordMap = this.readAllRecordsInJsonResource(baseResource, schema);
        TypeInfo outputSchema = recordMap.lastEntry().getValue().getTypeInfo();
        for (Map.Entry<String, OrcRowIterator> entry : recordMap.entrySet()) {
            this.writeAsOrcBinary(entry.getValue(), outputSchema, new Path(targetPath, AvroTestTools.removeExtension(entry.getKey())));
        }
        return outputSchema;
    }

    private void writeAsOrcBinary(OrcRowIterator input, TypeInfo schema, Path outputPath) throws IOException {
        Configuration configuration = new Configuration();
        ObjectInspector oi = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)schema);
        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)configuration).inspector(oi);
        Writer writer = null;
        while (input.hasNext()) {
            AvroRow avroRow = (AvroRow)input.next();
            if (writer == null) {
                options.inspector(avroRow.getInspector());
                writer = OrcFile.createWriter((Path)outputPath, (OrcFile.WriterOptions)options);
            }
            writer.addRow(avroRow.realRow);
        }
        if (writer != null) {
            writer.close();
        }
    }

    @Override
    public TreeMap<String, OrcRowIterator> readAllRecordsInJsonResource(String baseResource, @Nullable TypeInfo schema) throws IOException {
        TypeInfo orcSchema;
        try {
            if (schema == null) {
                File schemaFile = new File(baseResource, "schema.avsc");
                String schemaResource = schemaFile.toString();
                orcSchema = OrcTestTools.convertAvroSchemaToOrcSchema(AvroTestTools.readAvscSchema(schemaResource, OrcTestTools.class));
            } else {
                orcSchema = schema;
            }
        }
        catch (SerDeException se) {
            throw new RuntimeException("Provided Avro Schema cannot be transformed to ORC schema", se);
        }
        TreeMap<String, OrcRowIterator> output = new TreeMap<String, OrcRowIterator>();
        for (String file : AvroTestTools.getJsonFileSetByResourceRootName(baseResource)) {
            log.info("Reading json record from " + file);
            String name = PathUtils.relativizePath((Path)new Path(file), (Path)new Path(baseResource)).toString();
            output.put(name, this.readRecordsFromJsonInputStream(orcSchema, file));
        }
        return output;
    }

    private OrcRowIterator readRecordsFromJsonInputStream(TypeInfo typeInfo, String file) throws IOException {
        InputStream is = OrcTestTools.class.getClassLoader().getResourceAsStream(file);
        String schemaResourceName = new File(new File(file).getParentFile().getParent(), "schema.avsc").toString();
        Schema attemptedSchema = AvroTestTools.readAvscSchema(schemaResourceName, OrcTestTools.class);
        Schema avroSchema = attemptedSchema == null ? AvroTestTools.readAvscSchema(new File(new File(file).getParent(), "schema.avsc").toString(), OrcTestTools.class) : attemptedSchema;
        final GenericDatumReader reader = new GenericDatumReader(avroSchema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(avroSchema, is);
        return new OrcRowIterator(typeInfo, (Iterator<Writable>)new AbstractIterator<Writable>((Decoder)decoder, avroSchema, is){
            final /* synthetic */ Decoder val$decoder;
            final /* synthetic */ Schema val$avroSchema;
            final /* synthetic */ InputStream val$is;
            {
                this.val$decoder = decoder;
                this.val$avroSchema = schema;
                this.val$is = inputStream;
            }

            protected Writable computeNext() {
                try {
                    GenericRecord record = (GenericRecord)reader.read(null, this.val$decoder);
                    return OrcTestTools.this.getAvroWritable(record, this.val$avroSchema);
                }
                catch (IOException e) {
                    try {
                        this.val$is.close();
                    }
                    catch (IOException ioec) {
                        log.warn("Failed to read record from inputstream, will close it immediately", (Throwable)ioec);
                    }
                    this.endOfData();
                    return null;
                }
            }
        });
    }

    private Writable getAvroWritable(GenericRecord record, Schema avroSchema) {
        try {
            AvroSerDe serDe = new AvroSerDe();
            Properties propertiesWithSchema = new Properties();
            propertiesWithSchema.setProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), avroSchema.toString());
            serDe.initialize(null, propertiesWithSchema);
            AvroGenericRecordWritable avroGenericRecordWritable = new AvroGenericRecordWritable(record);
            avroGenericRecordWritable.setFileSchema(avroSchema);
            Object avroDeserialized = serDe.deserialize((Writable)avroGenericRecordWritable);
            ObjectInspector avroOI = new AvroObjectInspectorGenerator(avroSchema).getObjectInspector();
            return new AvroRow(avroDeserialized, avroOI);
        }
        catch (SerDeException se) {
            throw new RuntimeException("Failed in SerDe exception:", se);
        }
    }

    @Override
    public TreeMap<String, OrcRowIterator> readAllRecordsInBinaryDirectory(FileSystem fs, Path path) throws IOException {
        TreeMap<String, OrcRowIterator> output = new TreeMap<String, OrcRowIterator>();
        if (!fs.exists(path)) {
            return output;
        }
        HiddenFilter pathFilter = new HiddenFilter();
        for (FileStatus status : FileListUtils.listFilesRecursively((FileSystem)fs, (Path)path, (PathFilter)pathFilter)) {
            String key = PathUtils.relativizePath((Path)status.getPath(), (Path)path).toString();
            Reader orcReader = OrcFile.createReader((FileSystem)fs, (Path)status.getPath());
            final RecordReader recordReader = orcReader.rows();
            output.put(key, new OrcRowIterator(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)orcReader.getObjectInspector()), (Iterator<Writable>)new AbstractIterator<Writable>(){

                protected Writable computeNext() {
                    try {
                        if (recordReader.hasNext()) {
                            return (Writable)recordReader.next(null);
                        }
                        recordReader.close();
                        this.endOfData();
                        return null;
                    }
                    catch (IOException ioe) {
                        log.warn("Failed to process orc record reader, will terminate reader immediately", (Throwable)ioe);
                        this.endOfData();
                        return null;
                    }
                }
            }));
        }
        return output;
    }

    public static TypeInfo convertAvroSchemaToOrcSchema(Schema avroSchema) throws SerDeException {
        return TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)new AvroObjectInspectorGenerator(avroSchema).getObjectInspector());
    }

    public static class OrcRowIterator
    implements Iterator<Writable> {
        private final TypeInfo typeInfo;
        private final Iterator<Writable> it;

        @ConstructorProperties(value={"typeInfo", "it"})
        public OrcRowIterator(TypeInfo typeInfo, Iterator<Writable> it) {
            this.typeInfo = typeInfo;
            this.it = it;
        }

        public TypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Writable next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super Writable> arg0) {
            this.it.forEachRemaining(arg0);
        }
    }

    public static class AvroRow
    implements Writable {
        Object realRow;
        ObjectInspector inspector;

        public AvroRow(Object row, ObjectInspector inspector) {
            this.realRow = row;
            this.inspector = inspector;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("can't write the bundle");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("can't read the bundle");
        }

        ObjectInspector getInspector() {
            return this.inspector;
        }

        Object getRow() {
            return this.realRow;
        }
    }
}

