/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.binary_creation;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataTestTools<T, S> {
    private static final Logger log = LoggerFactory.getLogger(DataTestTools.class);

    public abstract boolean checkSameFilesAndRecords(TreeMap<String, T> var1, TreeMap<String, T> var2, boolean var3, Collection<String> var4, boolean var5);

    public abstract S writeJsonResourceRecordsAsBinary(String var1, FileSystem var2, Path var3, S var4) throws IOException;

    public abstract TreeMap<String, T> readAllRecordsInJsonResource(String var1, S var2) throws IOException;

    public abstract TreeMap<String, T> readAllRecordsInBinaryDirectory(FileSystem var1, Path var2) throws IOException;

    <T> boolean compareIterators(Iterator<T> expected, Iterator<T> observed, BiFunction<T, T, Boolean> comparator) {
        while (expected.hasNext()) {
            if (!observed.hasNext()) {
                log.error("Expected has more elements than observed.");
                return false;
            }
            T t1 = expected.next();
            T t2 = observed.next();
            boolean equals = comparator == null ? t1.equals(t2) : comparator.apply(t1, t2).booleanValue();
            if (equals) continue;
            log.error(String.format("Mismatch: %s does not equal %s.", t1, t2));
            return false;
        }
        if (observed.hasNext()) {
            log.error("Observed has more elements than expected.");
            return false;
        }
        return true;
    }
}

