/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.binary_creation;

import com.google.common.collect.AbstractIterator;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.mapred.FsInput;
import org.apache.gobblin.binary_creation.DataTestTools;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.filters.HiddenFilter;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroTestTools
extends DataTestTools<RecordIterator, Schema> {
    private static final Logger log = LoggerFactory.getLogger(AvroTestTools.class);

    @Override
    public boolean checkSameFilesAndRecords(TreeMap<String, RecordIterator> expected, TreeMap<String, RecordIterator> observed, boolean allowDifferentOrder, Collection<String> blacklistRecordFields, boolean allowDifferentSchema) {
        Iterator<String> keys1 = expected.navigableKeySet().iterator();
        Iterator<String> keys2 = observed.navigableKeySet().iterator();
        return this.compareIterators(keys1, keys2, (key1, key2) -> {
            if (!AvroTestTools.removeExtension(key1).equals(AvroTestTools.removeExtension(key2))) {
                log.error(String.format("Mismatched files: %s and %s", key1, key2));
                return false;
            }
            RecordIterator it1 = (RecordIterator)expected.get(key1);
            RecordIterator it2 = (RecordIterator)observed.get(key2);
            if (!allowDifferentSchema && !it1.getSchema().equals((Object)it2.getSchema())) {
                log.error(String.format("Mismatched schemas: %s and %s", key1, key2));
                return false;
            }
            if (allowDifferentOrder) {
                Set<GenericRecordWrapper> r22;
                Set<GenericRecordWrapper> r12 = allowDifferentSchema ? AvroTestTools.toSetWithBlacklistedFields(it1, blacklistRecordFields, GenericRecordWrapper::new) : AvroTestTools.toSetWithBlacklistedFields(it1, blacklistRecordFields, Function.identity());
                Set<GenericRecordWrapper> set = r22 = allowDifferentSchema ? AvroTestTools.toSetWithBlacklistedFields(it2, blacklistRecordFields, GenericRecordWrapper::new) : AvroTestTools.toSetWithBlacklistedFields(it2, blacklistRecordFields, Function.identity());
                if (r12.equals(r22)) {
                    return true;
                }
                log.info("Sets of records differ.");
                return false;
            }
            return this.compareIterators(it1, it2, (r1, r2) -> {
                if (blacklistRecordFields != null) {
                    for (String blacklisted : blacklistRecordFields) {
                        r1.put(blacklisted, null);
                        r2.put(blacklisted, null);
                    }
                }
                return allowDifferentSchema ? GenericRecordWrapper.compareGenericRecordRegardlessOfSchema(r1, r2) : r1.equals(r2);
            });
        });
    }

    private static <T> Set<T> toSetWithBlacklistedFields(Iterator<GenericRecord> it, Collection<String> blacklistRecordFields, Function<GenericRecord, T> transform) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 0), false).map(r -> {
            for (String blacklisted : blacklistRecordFields) {
                r.put(blacklisted, null);
            }
            return transform.apply((GenericRecord)r);
        }).collect(Collectors.toSet());
    }

    @Override
    public TreeMap<String, RecordIterator> readAllRecordsInBinaryDirectory(FileSystem fs, Path path) throws IOException {
        TreeMap<String, RecordIterator> output = new TreeMap<String, RecordIterator>();
        if (!fs.exists(path)) {
            return output;
        }
        HiddenFilter pathFilter = new HiddenFilter();
        for (FileStatus status : FileListUtils.listFilesRecursively((FileSystem)fs, (Path)path, (PathFilter)pathFilter)) {
            FsInput sin = new FsInput(status.getPath(), fs);
            final DataFileReader dfr = new DataFileReader((SeekableInput)sin, (DatumReader)new GenericDatumReader());
            String key = PathUtils.relativizePath((Path)status.getPath(), (Path)path).toString();
            output.put(key, new RecordIterator(dfr.getSchema(), (Iterator<GenericRecord>)new AbstractIterator<GenericRecord>(){

                protected GenericRecord computeNext() {
                    if (dfr.hasNext()) {
                        return (GenericRecord)dfr.next();
                    }
                    try {
                        dfr.close();
                    }
                    catch (IOException ioe) {
                        log.error("Failed to close data file reader.", (Throwable)ioe);
                    }
                    this.endOfData();
                    return null;
                }
            }));
        }
        return output;
    }

    @Override
    public TreeMap<String, RecordIterator> readAllRecordsInJsonResource(String baseResource, @Nullable Schema schema) throws IOException {
        if (schema == null) {
            String schemaResource = new File(baseResource, "schema.avsc").toString();
            schema = AvroTestTools.readAvscSchema(schemaResource, AvroTestTools.class);
        }
        TreeMap<String, RecordIterator> output = new TreeMap<String, RecordIterator>();
        for (String file : AvroTestTools.getJsonFileSetByResourceRootName(baseResource)) {
            log.info("Reading json record from " + file);
            String name = PathUtils.relativizePath((Path)new Path(file), (Path)new Path(baseResource)).toString();
            String schemaResourceName = new File(new File(file).getParent(), "schema.avsc").toString();
            Schema thisSchema = AvroTestTools.readAvscSchema(schemaResourceName, AvroTestTools.class);
            Schema actualSchema = thisSchema == null ? schema : thisSchema;
            InputStream is = AvroTestTools.class.getClassLoader().getResourceAsStream(file);
            Throwable throwable = null;
            try {
                output.put(name, AvroTestTools.readRecordsFromJsonInputStream(actualSchema, is, (Decoder)DecoderFactory.get().jsonDecoder(actualSchema, is)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return output;
    }

    private static RecordIterator readRecordsFromJsonInputStream(Schema schema, final InputStream is, final Decoder decoder) {
        final GenericDatumReader reader = new GenericDatumReader(schema);
        return new RecordIterator(schema, (Iterator<GenericRecord>)new AbstractIterator<GenericRecord>(){

            protected GenericRecord computeNext() {
                try {
                    return (GenericRecord)reader.read(null, decoder);
                }
                catch (IOException ioe) {
                    try {
                        is.close();
                    }
                    catch (IOException exc) {
                        log.warn("Failed to close input stream.", (Throwable)exc);
                    }
                    this.endOfData();
                    return null;
                }
            }
        });
    }

    @Override
    public Schema writeJsonResourceRecordsAsBinary(String baseResource, FileSystem fs, Path targetPath, @Nullable Schema schema) throws IOException {
        TreeMap<String, RecordIterator> recordMap = this.readAllRecordsInJsonResource(baseResource, schema);
        Schema outputSchema = recordMap.lastEntry().getValue().getSchema();
        for (Map.Entry<String, RecordIterator> entry : recordMap.entrySet()) {
            this.writeAsAvroBinary(entry.getValue(), entry.getValue().getSchema(), fs, new Path(targetPath, AvroTestTools.removeExtension(entry.getKey()) + ".avro"));
        }
        return outputSchema;
    }

    public static Schema readAvscSchema(String resource, Class loadedClass) throws IOException {
        try (InputStream is = loadedClass.getClassLoader().getResourceAsStream(resource);){
            Schema schema = is != null ? new Schema.Parser().parse(is) : null;
            return schema;
        }
    }

    private void writeAsAvroBinary(Iterator<GenericRecord> input, Schema schema, FileSystem fs, Path outputPath) throws IOException {
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        writer.create(schema, (OutputStream)fs.create(outputPath, true));
        while (input.hasNext()) {
            writer.append((Object)input.next());
        }
        writer.close();
        log.info("Successfully wrote avro file to path " + outputPath);
    }

    static String removeExtension(String string) {
        if (string.endsWith(".avro") || string.endsWith(".json")) {
            return string.substring(0, string.length() - 5);
        }
        throw new IllegalArgumentException("Only support avro and json extensions.");
    }

    static Set<String> getJsonFileSetByResourceRootName(String baseResource) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(new String[]{baseResource}).filterInputsBy(name -> name.startsWith(baseResource)).setScanners(new Scanner[]{new ResourcesScanner()}));
        return reflections.getResources(url -> url.endsWith(".json"));
    }

    public static boolean isResourceExisted(String resource) throws IOException {
        return AvroTestTools.class.getClassLoader().getResource(resource) != null;
    }

    public static class GenericRecordWrapper {
        public GenericRecord record;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericRecordWrapper that = (GenericRecordWrapper)o;
            return GenericRecordWrapper.compareGenericRecordRegardlessOfSchema(this.record, that.record);
        }

        public int hashCode() {
            int indexLen = this.record.getSchema().getFields().size();
            Object[] objArr = new Object[indexLen];
            for (int i = 0; i < indexLen; ++i) {
                objArr[i] = this.record.get(i);
            }
            return Objects.hash(objArr);
        }

        static boolean compareGenericRecordRegardlessOfSchema(GenericRecord r1, GenericRecord r2) {
            List listOfFields1 = r1.getSchema().getFields();
            List listOfFields2 = r2.getSchema().getFields();
            if (listOfFields1.size() != listOfFields2.size()) {
                return false;
            }
            boolean result = true;
            for (int i = 0; i < listOfFields1.size(); ++i) {
                result = result && (r1.get(i) == null && r2.get(i) == null || ((Schema.Field)listOfFields1.get(i)).name().equals(((Schema.Field)listOfFields2.get(i)).name()) && r1.get(i).equals(r2.get(i)));
            }
            return result;
        }

        @ConstructorProperties(value={"record"})
        public GenericRecordWrapper(GenericRecord record) {
            this.record = record;
        }
    }

    public static class RecordIterator
    implements Iterator<GenericRecord> {
        private final Schema schema;
        private final Iterator<GenericRecord> it;

        @ConstructorProperties(value={"schema", "it"})
        public RecordIterator(Schema schema, Iterator<GenericRecord> it) {
            this.schema = schema;
            this.it = it;
        }

        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public GenericRecord next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super GenericRecord> arg0) {
            this.it.forEachRemaining(arg0);
        }
    }
}

