/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public abstract class HBaseVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    protected static final TableInputFormat BASE_FORMAT = new TableInputFormat();
    private static final Logger LOG = Logger.getLogger(HBaseVertexInputFormat.class);

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        BASE_FORMAT.setConf((Configuration)this.getConf());
        return BASE_FORMAT.getSplits(context);
    }

    public static abstract class HBaseVertexReader<I extends WritableComparable, V extends Writable, E extends Writable>
    extends VertexReader<I, V, E> {
        private final RecordReader<ImmutableBytesWritable, Result> reader;
        private TaskAttemptContext context;

        public HBaseVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
            BASE_FORMAT.setConf(context.getConfiguration());
            this.reader = BASE_FORMAT.createRecordReader(split, context);
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.reader.initialize(inputSplit, context);
            this.context = context;
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.reader.getProgress();
        }

        protected RecordReader<ImmutableBytesWritable, Result> getRecordReader() {
            return this.reader;
        }

        protected TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

