/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="nvl", value="_FUNC_(value,default_value) - Returns default value if value is null else returns value", extended="Example:\n  > SELECT _FUNC_(null,'bla') FROM src LIMIT 1;\n  bla")
public class GenericUDFNvl
extends GenericUDF {
    private GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;
    private ObjectInspector[] argumentOIs;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.argumentOIs = arguments;
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The operator 'NVL'  accepts 2 arguments.");
        }
        this.returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        if (!this.returnOIResolver.update(arguments[0]) || !this.returnOIResolver.update(arguments[1])) {
            throw new UDFArgumentTypeException(2, "The first and seconds arguments of function NLV should have the same type, but they are different: \"" + arguments[0].getTypeName() + "\" and \"" + arguments[1].getTypeName() + "\"");
        }
        return this.returnOIResolver.get();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object retVal = this.returnOIResolver.convertIfNecessary(arguments[0].get(), this.argumentOIs[0]);
        if (retVal == null) {
            retVal = this.returnOIResolver.convertIfNecessary(arguments[1].get(), this.argumentOIs[1]);
        }
        return retVal;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("if ");
        sb.append(children[0]);
        sb.append(" is null ");
        sb.append("returns");
        sb.append(children[1]);
        return sb.toString();
    }
}

